/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.google.common.base.Predicates;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.Accessor;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.ui.ItemStackElement;

public class RayTracing {
    public static final RayTracing INSTANCE = new RayTracing();
    private HitResult target = null;
    private final Minecraft mc = Minecraft.m_91087_();
    public static Predicate<Entity> ENTITY_FILTER = Predicates.alwaysTrue();

    private RayTracing() {
    }

    public void fire() {
        Entity targetEntity;
        Entity viewpoint = this.mc.m_91288_();
        if (viewpoint == null) {
            return;
        }
        if (this.mc.f_91077_ != null && this.mc.f_91077_.m_6662_() == HitResult.Type.ENTITY && this.canBeTarget(targetEntity = ((EntityHitResult)this.mc.f_91077_).m_82443_(), viewpoint)) {
            this.target = this.mc.f_91077_;
            return;
        }
        float reach = this.mc.f_91072_.m_105286_() + Jade.CONFIG.get().getGeneral().getReachDistance();
        this.target = this.rayTrace(viewpoint, reach, this.mc.m_91296_());
    }

    public HitResult getTarget() {
        return this.target;
    }

    public HitResult rayTrace(Entity entity, double playerReach, float partialTicks) {
        BlockState state;
        Vec3 traceEnd;
        Vec3 eyePosition = entity.m_20299_(partialTicks);
        if (this.mc.f_91077_ != null && this.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            traceEnd = this.mc.f_91077_.m_82450_();
            traceEnd = eyePosition.m_82549_(traceEnd.m_82546_(eyePosition).m_82490_(1.01));
        } else {
            Vec3 lookVector = entity.m_20252_(partialTicks);
            traceEnd = eyePosition.m_82520_(lookVector.f_82479_ * playerReach, lookVector.f_82480_ * playerReach, lookVector.f_82481_ * playerReach);
        }
        Level world = entity.f_19853_;
        AABB bound = new AABB(eyePosition, traceEnd);
        Predicate<Entity> predicate = e -> this.canBeTarget((Entity)e, entity);
        EntityHitResult entityResult = RayTracing.getEntityHitResult(world, entity, eyePosition, traceEnd, bound, predicate);
        if (this.mc.f_91077_ != null && this.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 lookVector = entity.m_20252_(partialTicks);
            traceEnd = eyePosition.m_82520_(lookVector.f_82479_ * playerReach, lookVector.f_82480_ * playerReach, lookVector.f_82481_ * playerReach);
        }
        Block eyeBlock = world.m_8055_(new BlockPos(eyePosition.f_82479_, eyePosition.f_82480_, eyePosition.f_82481_)).m_60734_();
        ClipContext.Fluid fluidView = ClipContext.Fluid.NONE;
        if (!(eyeBlock instanceof LiquidBlock)) {
            fluidView = Jade.CONFIG.get().getGeneral().getDisplayFluids().ctx;
        }
        ClipContext context = new ClipContext(eyePosition, traceEnd, ClipContext.Block.OUTLINE, fluidView, entity);
        BlockHitResult blockResult = world.m_45547_(context);
        if (entityResult != null && blockResult != null) {
            if (blockResult.m_6662_() == HitResult.Type.BLOCK) {
                double blockDist;
                double entityDist = entityResult.m_82450_().m_82557_(eyePosition);
                if (entityDist < (blockDist = blockResult.m_82450_().m_82557_(eyePosition))) {
                    return entityResult;
                }
            } else {
                return entityResult;
            }
        }
        if (blockResult != null && blockResult.m_6662_() == HitResult.Type.BLOCK && WailaClientRegistration.INSTANCE.shouldHide(state = world.m_8055_(blockResult.m_82425_()))) {
            return null;
        }
        return blockResult;
    }

    private boolean canBeTarget(Entity target, Entity viewEntity) {
        if (target.m_5833_()) {
            return false;
        }
        if (target == viewEntity.m_20202_()) {
            return false;
        }
        if (viewEntity instanceof Player ? target.m_20177_((Player)viewEntity) : target.m_20145_()) {
            return false;
        }
        return !WailaClientRegistration.INSTANCE.shouldHide(target) && ENTITY_FILTER.test(target);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level worldIn, Entity projectile, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : worldIn.m_6249_(projectile, boundingBox, filter)) {
            double d1;
            AABB axisalignedbb = entity1.m_20191_();
            if (axisalignedbb.m_82309_() < 0.3) {
                axisalignedbb = axisalignedbb.m_82400_(0.3);
            }
            if (axisalignedbb.m_82390_(startVec)) {
                entity = entity1;
                d0 = 0.0;
                break;
            }
            Optional optional = axisalignedbb.m_82371_(startVec, endVec);
            if (!optional.isPresent() || !((d1 = startVec.m_82557_((Vec3)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }

    public IElement getIcon() {
        Accessor<?> accessor = ObjectDataCenter.get();
        if (accessor == null) {
            return null;
        }
        IElement icon = accessor._getIcon();
        if (RayTracing.isEmptyElement(icon)) {
            return null;
        }
        return icon;
    }

    public static boolean isEmptyElement(IElement element) {
        return element == null || element == ItemStackElement.EMPTY;
    }
}

