/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import snownee.jade.gui.config.WailaOptionsList;

public abstract class OptionValue<T>
extends WailaOptionsList.Entry {
    private final Component title;
    protected final Consumer<T> setter;
    protected T value;
    private int x;
    public int indent;

    public OptionValue(String optionName, Consumer<T> setter) {
        this.title = OptionValue.makeTitle(optionName);
        this.setter = setter;
        String key = OptionValue.makeKey(optionName + "_desc");
        if (I18n.m_118936_((String)key)) {
            this.appendDescription(I18n.m_118938_((String)key, (Object[])new Object[0]));
        }
    }

    @Override
    public final void m_6311_(PoseStack matrixStack, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        Component title0 = this.getListener().f_93623_ ? this.title : this.title.m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.STRIKETHROUGH, ChatFormatting.GRAY});
        Font font = this.client.f_91062_;
        float f = rowLeft + this.indent + 10;
        int n = rowTop + height / 4;
        Objects.requireNonNull(this.client.f_91062_);
        font.m_92763_(matrixStack, title0, f, (float)(n + 9 / 2), 0xFFFFFF);
        this.drawValue(matrixStack, width, height, rowLeft + width - 110, rowTop, mouseX, mouseY, hovered, deltaTime);
        this.x = rowLeft;
    }

    public void save() {
        this.setter.accept(this.value);
    }

    public Component getTitle() {
        return this.title;
    }

    public void appendDescription(String description) {
        if (this.description == null) {
            this.description = this.getTitle().getString();
        }
        this.description = this.description + "\n" + description;
    }

    public int getX() {
        return this.x;
    }

    @Override
    public int getTextX(int width) {
        return this.getX() + this.indent + 10;
    }

    @Override
    public int getTextWidth() {
        return this.client.f_91062_.m_92852_((FormattedText)this.getTitle());
    }

    public void m_168854_(NarrationElementOutput output) {
        this.getListener().m_142291_(output);
        if (!Strings.isNullOrEmpty((String)this.getDescription())) {
            output.m_169146_(NarratedElementType.HINT, (Component)Component.m_237115_((String)this.getDescription()));
        }
    }

    protected abstract void drawValue(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

    @Override
    public List<? extends AbstractWidget> m_6702_() {
        return Lists.newArrayList((Object[])new AbstractWidget[]{this.getListener()});
    }
}

