/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.impl.ui.ScaledTextElement;

public enum ProgressProvider implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ProgressProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity tile, boolean showDetails) {
        ProgressProvider.putData(data, player, tile, showDetails);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.UNIVERSAL_PROGRESS;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (accessor.getServerData().m_128441_("JadeProgress")) {
            Optional<IClientExtensionProvider> provider = Optional.ofNullable(ResourceLocation.m_135820_((String)accessor.getServerData().m_128461_("JadeProgressUid"))).map(WailaClientRegistration.INSTANCE.progressProviders::get);
            if (provider.isPresent()) {
                List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeProgress", Function.identity()));
                if (groups.isEmpty()) {
                    return;
                }
                IElementHelper helper = IElementHelper.get();
                boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
                BoxStyle box = new BoxStyle();
                box.bgColor = -2013265920;
                ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
                    if (renderGroup) {
                        if (group.title != null) {
                            theTooltip.add(new HorizontalLineElement());
                            theTooltip.append(new ScaledTextElement(group.title, 0.5f));
                            theTooltip.append(new HorizontalLineElement());
                        } else if (group.bgColor == 0) {
                            theTooltip.add(new HorizontalLineElement());
                        }
                    }
                    for (ProgressView view : group.views) {
                        if (view.text != null) {
                            theTooltip.add(new ScaledTextElement(view.text, 0.75f));
                        }
                        theTooltip.add(helper.progress(view.progress, null, view.style, box, false).size(new Vec2(10.0f, 4.0f)));
                    }
                });
            }
        }
    }

    public static void putData(CompoundTag tag, ServerPlayer player, Object target, boolean showDetails) {
        List<IServerExtensionProvider<Object, CompoundTag>> list = WailaCommonRegistration.INSTANCE.progressProviders.get(target);
        for (IServerExtensionProvider<Object, CompoundTag> provider : list) {
            List groups = provider.getGroups(player, player.m_9236_(), target, showDetails);
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeProgress", groups, Function.identity())) {
                tag.m_128359_("JadeProgressUid", provider.getUid().toString());
            }
            return;
        }
    }
}

