/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.network.FriendlyByteBuf;

public final class StepFunction
implements Float2FloatFunction {
    protected final float min;
    protected final int steps;
    protected final float step;

    public StepFunction(float min, int steps, float step) {
        this.min = min;
        this.steps = steps;
        this.step = step;
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
    }

    public float get(float level) {
        return this.min + (float)((int)((float)this.steps * (level + 0.5f / (float)this.steps))) * this.step;
    }

    public int getInt(float level) {
        return (int)this.get(level);
    }

    public float min() {
        return this.min;
    }

    public float max() {
        return this.min + (float)this.steps * this.step;
    }

    public int steps() {
        return this.steps;
    }

    public int getStep(float level) {
        return (int)((float)this.steps * (level + 0.5f / (float)this.steps));
    }

    public float getForStep(int step) {
        return this.min + this.step * (float)step;
    }

    public float getIntForStep(int step) {
        return (int)this.getForStep(step);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.min);
        buf.writeInt(this.steps);
        buf.writeFloat(this.step);
    }

    public static StepFunction read(FriendlyByteBuf buf) {
        return new StepFunction(buf.readFloat(), buf.readInt(), buf.readFloat());
    }

    public static StepFunction constant(float val) {
        return new StepFunction(val, 1, 0.0f);
    }
}

