/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import shadows.placebo.json.ListenerCallback;
import shadows.placebo.json.PlaceboJsonReloadListener;

public class DynamicRegistryObject<T extends PlaceboJsonReloadListener.TypeKeyed<? super T>>
implements Supplier<T>,
ListenerCallback {
    protected final ResourceLocation id;
    protected final PlaceboJsonReloadListener<? super T> manager;
    protected T object;

    public DynamicRegistryObject(ResourceLocation id, PlaceboJsonReloadListener<? super T> manager) {
        this.id = id;
        this.manager = manager;
    }

    @Override
    public T get() {
        return this.object == null ? (this.object = this.manager.getValue(this.id)) : this.object;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean isPresent() {
        return this.object != null || this.manager.getValue(this.id) != null;
    }

    public void invalidate() {
        this.object = null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    public void beginReload(PlaceboJsonReloadListener manager) {
        this.invalidate();
    }

    public void onReload(PlaceboJsonReloadListener manager) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof DynamicRegistryObject)) return false;
        DynamicRegistryObject dObj = (DynamicRegistryObject)obj;
        if (dObj.manager != this.manager) return false;
        if (!dObj.id.equals((Object)this.id)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.manager});
    }
}

