/*
 * Decompiled with CFR 0.152.
 */
package com.logprot.players;

import com.logprot.Logprot;
import com.logprot.Utils.BlockPosUtils;
import com.logprot.event.PlayerEventHandler;
import com.logprot.players.PlayerData;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

public class PlayerManager {
    private static PlayerManager instance;
    private boolean debug;
    private WeakHashMap<UUID, PlayerData> playerDataMap;

    private PlayerManager() {
        this.debug = (Boolean)Logprot.getConfig().getCommon().debugOutput.get();
        this.playerDataMap = new WeakHashMap();
    }

    public static PlayerManager getInstance() {
        if (instance == null) {
            instance = new PlayerManager();
        }
        return instance;
    }

    public void onPlayerLogin(Player player) {
        if (this.playerDataMap.containsKey(player.m_20148_())) {
            return;
        }
        this.playerDataMap.put(player.m_20148_(), new PlayerData(player, player.m_20183_(), (Integer)Logprot.getConfig().getCommon().invulTime.get()));
        if (this.debug) {
            Logprot.LOGGER.info("Player:" + player.m_5446_().getString() + " now has protection for " + Logprot.getConfig().getCommon().invulTime.get() + " ticks");
        }
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register((Object)PlayerEventHandler.getInstance());
    }

    public void updatePlayers() {
        if (this.playerDataMap.isEmpty()) {
            return;
        }
        double maxDist = Math.pow(((Integer)Logprot.getConfig().getCommon().maxDist.get()).intValue(), 2.0);
        Iterator<Map.Entry<UUID, PlayerData>> iterator = this.playerDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PlayerData> entry = iterator.next();
            if (!((double)BlockPosUtils.dist2DSQ(entry.getValue().loginPos, entry.getValue().player.m_20183_()) > maxDist) && entry.getValue().invulTime-- > 0) continue;
            if (this.debug) {
                Logprot.LOGGER.info("Player:" + entry.getValue().player.m_5446_().getString() + " got his protection removed");
            }
            entry.getValue().player.f_20916_ = 0;
            iterator.remove();
        }
        if (this.playerDataMap.isEmpty()) {
            ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).unregister((Object)PlayerEventHandler.getInstance());
        }
    }

    public boolean isPlayerImmune(Player playerEntity) {
        return this.playerDataMap.containsKey(playerEntity.m_20148_());
    }
}

