/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;

public final class FlatSlopeSlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        boolean topHalf;
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (top == (topHalf = ((Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF)).booleanValue()) && (topHalf && side == Direction.UP || !topHalf && side == Direction.DOWN)) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return switch (blockType) {
                case BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstFlatSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(FlatSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(SlopeSlabSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean topHalf, boolean top, Direction side) {
        if (side == dir || side == dir.m_122428_()) {
            Direction longEdge = top ? Direction.UP : Direction.DOWN;
            return HalfTriangleDir.fromDirections(longEdge, dir, topHalf == top);
        }
        return HalfTriangleDir.NULL;
    }
}

