/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;

public final class FlatInnerSlopeSlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        boolean topHalf;
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (top == (topHalf = ((Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF)).booleanValue()) && (topHalf && side == Direction.UP || !topHalf && side == Direction.DOWN)) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return switch (blockType) {
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDoubleSlopeSlab(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstInverseDoubleSlopeSlab(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedDoubleSlopeSlab(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(level, pos, state, dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDoubleSlab(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStairs(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalDoubleHalfSlope(level, pos, state, dir, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopedStairs(level, pos, state, dir, topHalf, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstFlatInnerSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(FlatSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(SlopeSlabSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstElevatedSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstElevatedDoubleSlopeSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedSlopeSlab(level, pos, state, dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatElevatedSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(level, pos, state, dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(level, pos, state, dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(level, pos, state, dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(level, pos, state, dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStairs(level, pos, state, dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) != SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, topHalf, (BlockState)states.m_14418_(), side) || FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(level, pos, state, dir, topHalf, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(dir, topHalf, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean topHalf, boolean top, Direction side) {
        if (side == dir.m_122424_() || side == dir.m_122427_()) {
            Direction longEdge = top ? Direction.UP : Direction.DOWN;
            return HalfTriangleDir.fromDirections(longEdge, dir, topHalf == top);
        }
        return HalfTriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, boolean topHalf, Direction side) {
        if (side == dir || side == dir.m_122428_()) {
            return HalfDir.fromDirections(side, topHalf ? Direction.DOWN : Direction.UP);
        }
        return HalfDir.NULL;
    }
}

