/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.CornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;
import xfacthd.framedblocks.common.util.FramedUtils;

public final class HalfSlopeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
            return switch (blockType) {
                case BlockType.FRAMED_HALF_SLOPE -> HalfSlopeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> HalfSlopeSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> HalfSlopeSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> HalfSlopeSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE, BlockType.FRAMED_POWERED_RAIL_SLOPE, BlockType.FRAMED_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_ACTIVATOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_RAIL_SLOPE, BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE, BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE -> HalfSlopeSkipPredicate.testAgainstSlope(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE -> HalfSlopeSkipPredicate.testAgainstDoubleSlope(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE -> HalfSlopeSkipPredicate.testAgainstCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE -> HalfSlopeSkipPredicate.testAgainstInnerCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_CORNER -> HalfSlopeSkipPredicate.testAgainstDoubleCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_PRISM_CORNER, BlockType.FRAMED_THREEWAY_CORNER -> HalfSlopeSkipPredicate.testAgainstThreewayCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_INNER_THREEWAY_CORNER -> HalfSlopeSkipPredicate.testAgainstInnerThreewayCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM_CORNER, BlockType.FRAMED_DOUBLE_THREEWAY_CORNER -> HalfSlopeSkipPredicate.testAgainstDoubleThreewayCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> HalfSlopeSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_PANEL -> HalfSlopeSkipPredicate.testAgainstPanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> HalfSlopeSkipPredicate.testAgainstDoublePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> HalfSlopeSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_STAIRS -> HalfSlopeSkipPredicate.testAgainstStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> HalfSlopeSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> HalfSlopeSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> HalfSlopeSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> HalfSlopeSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> HalfSlopeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> HalfSlopeSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> HalfSlopeSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> HalfSlopeSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> HalfSlopeSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> HalfSlopeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> HalfSlopeSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> HalfSlopeSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> HalfSlopeSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> HalfSlopeSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, top, right, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfSlopeSkipPredicate.getTriDir(dir, top, right, side).isEqualTo(HalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (adjType == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstHalfSlope(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (HalfSlopeSkipPredicate.getTriDir(dir, top, right, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = FramedUtils.getSlopeBlockFacing(adjState);
        SlopeType adjType = FramedUtils.getSlopeType(adjState);
        if (HalfSlopeSkipPredicate.getTriDir(dir, top, right, side).isEqualTo(SlopeSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstSlope(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstSlope(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (HalfSlopeSkipPredicate.getTriDir(dir, top, right, side).isEqualTo(CornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstInnerCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        if (HalfSlopeSkipPredicate.getTriDir(dir, top, right, side).isEqualTo(InnerCornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstInnerCorner(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstCorner(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstThreewayCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (HalfSlopeSkipPredicate.getTriDir(dir, top, right, side).isEqualTo(ThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstInnerThreewayCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (HalfSlopeSkipPredicate.getTriDir(dir, top, right, side).isEqualTo(InnerThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleThreewayCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstInnerThreewayCorner(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstThreewayCorner(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return adjTop != top && SideSkipPredicate.compareState(level, pos, side, state, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, side.m_122424_());
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstPanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstPanel(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstStairs(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (HalfSlopeSkipPredicate.getHalfDir(dir, top, right, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, boolean top, boolean right, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return HalfSlopeSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, top, right, (BlockState)states.m_14418_(), side) || HalfSlopeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, top, right, (BlockState)states.m_14419_(), side);
    }

    public static TriangleDir getTriDir(Direction dir, boolean top, boolean right, Direction side) {
        if (!right && side == dir.m_122428_() || right && side == dir.m_122427_()) {
            return TriangleDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN);
        }
        return TriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, boolean top, boolean right, Direction side) {
        if (side == dir || !top && side == Direction.DOWN || top && side == Direction.UP) {
            return HalfDir.fromDirections(side, right ? dir.m_122427_() : dir.m_122428_());
        }
        return HalfDir.NULL;
    }
}

