/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.data.CamoContainer;
import xfacthd.framedblocks.api.data.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public class FramedFlatElevatedDoubleSlopeSlabCornerBlockEntity
extends FramedDoubleBlockEntity {
    private final boolean isInner = this.getBlockType() == BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER;

    public FramedFlatElevatedDoubleSlopeSlabCornerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeFramedFlatElevatedDoubleSlopeSlabCorner.get(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit) {
        double hor;
        Direction side = hit.m_82434_();
        boolean top = (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.TOP);
        if (side == Direction.UP) {
            return !top;
        }
        if (side == Direction.DOWN) {
            return top;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR);
        if (this.isInner && (side == facing || side == facing.m_122428_())) {
            return false;
        }
        Vec3 vec = Utils.fraction(hit.m_82450_());
        if (!(this.isInner || side != facing.m_122424_() && side != facing.m_122427_())) {
            return vec.m_7098_() >= 0.5 != top;
        }
        Direction perpDir = this.isInner ? (side == facing.m_122427_() ? facing : facing.m_122428_()) : (side == facing ? facing.m_122428_() : facing);
        double d = hor = Utils.isX(perpDir) ? vec.m_7096_() : vec.m_7094_();
        if (!Utils.isPositive(perpDir)) {
            hor = 1.0 - hor;
        }
        double y = vec.m_7098_();
        if (top) {
            y = 1.0 - y;
        }
        return (y -= 0.5) * 2.0 >= hor;
    }

    @Override
    public DoubleSoundMode getSoundMode() {
        return (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.TOP) != false ? DoubleSoundMode.FIRST : DoubleSoundMode.SECOND;
    }

    @Override
    public CamoContainer getCamo(Direction side) {
        Direction facing;
        if (Utils.isY(side)) {
            boolean top = (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.TOP);
            if (side == Direction.UP) {
                return top ? this.getCamo() : this.getCamoTwo();
            }
            if (side == Direction.DOWN) {
                return top ? this.getCamoTwo() : this.getCamo();
            }
        }
        if (side == (facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR)) || side == facing.m_122428_()) {
            return this.getCamo();
        }
        if (side == facing.m_122424_() || side == facing.m_122427_()) {
            return this.getCamoTwo();
        }
        return EmptyCamoContainer.EMPTY;
    }

    @Override
    public boolean isSolidSide(Direction side) {
        Direction facing;
        if (Utils.isY(side)) {
            boolean top = (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.TOP);
            CamoContainer camo = top == (side == Direction.UP) ? this.getCamo() : this.getCamoTwo();
            return camo.getState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        if (this.isInner && (side == (facing = (Direction)this.m_58900_().m_61143_((Property)FramedProperties.FACING_HOR)) || side == facing.m_122428_())) {
            return this.getCamo().getState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        return false;
    }
}

