/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.CtmPredicate;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slope.FramedHalfSlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedVerticalSlopedStairsBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = CtmPredicate.HOR_DIR.or((state, side) -> {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)((Object)state.m_61143_(PropertyHolder.ROTATION)));
        return side == rot.getOpposite().withFacing(facing) || side == rot.rotate(Rotation.CLOCKWISE_90).withFacing(facing);
    });

    public FramedVerticalSlopedStairsBlock() {
        super(BlockType.FRAMED_VERTICAL_SLOPED_STAIRS);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.SOLID, FramedProperties.GLOWING, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction facing = context.m_8125_();
        state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing);
        Direction face = context.m_43719_();
        HorizontalRotation rot = face == facing.m_122424_() ? HorizontalRotation.fromWallCorner(context.m_43720_(), face) : HorizontalRotation.fromPerpendicularWallCorner(facing, face, context.m_43720_());
        state = (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot));
        return FramedVerticalSlopedStairsBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        double frac;
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction face = hit.m_82434_();
        HorizontalRotation horRot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = horRot.withFacing(facing);
        Direction rotDirTwo = horRot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(facing);
        if (!Utils.isY(face) && (face == rotDir || face == rotDirTwo) && (frac = Utils.fractionInDir(hit.m_82450_(), facing.m_122424_())) >= 0.5) {
            face = Direction.UP;
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(facing));
        }
        if (face.m_122434_() == facing.m_122434_()) {
            HorizontalRotation horRot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)horRot.rotate(rot)));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        HorizontalRotation horRot;
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_());
        }
        horRot = (horRot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION))).isVertical() ? horRot.rotate(Rotation.CLOCKWISE_90) : horRot.rotate(Rotation.COUNTERCLOCKWISE_90);
        state = (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)horRot));
        return state;
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape panelShape = FramedVerticalSlopedStairsBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            VoxelShape slopeShape = switch ((HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION))) {
                default -> throw new IncompatibleClassChangeError();
                case HorizontalRotation.UP -> Utils.rotateShape(Direction.NORTH, Direction.EAST, FramedHalfSlopeBlock.SHAPE_BOTTOM_RIGHT);
                case HorizontalRotation.DOWN -> Utils.rotateShape(Direction.NORTH, Direction.WEST, FramedHalfSlopeBlock.SHAPE_TOP_LEFT);
                case HorizontalRotation.RIGHT -> Utils.rotateShape(Direction.NORTH, Direction.WEST, FramedHalfSlopeBlock.SHAPE_BOTTOM_LEFT);
                case HorizontalRotation.LEFT -> Utils.rotateShape(Direction.NORTH, Direction.EAST, FramedHalfSlopeBlock.SHAPE_TOP_RIGHT);
            };
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, Shapes.m_83110_((VoxelShape)slopeShape, (VoxelShape)panelShape)));
        }
        return builder.build();
    }
}

