/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.blockentity.FramedFlatInverseDoubleSlopePanelCornerBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatInverseDoubleSlopePanelCornerBlock
extends AbstractFramedDoubleBlock {
    public FramedFlatInverseDoubleSlopePanelCornerBlock() {
        super(BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, BlockStateProperties.f_61362_});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedFlatSlopePanelCornerBlock.getStateForPlacement(this, false, context);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction face = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        if (face == rotDir.m_122424_() || face == perpRotDir.m_122424_()) {
            if (Utils.fractionInDir(hit.m_82450_(), dir.m_122424_()) > 0.5) {
                face = dir.m_122424_();
            }
        } else if (face == rotDir || face == perpRotDir) {
            double perpHor;
            Direction perpDir;
            double hor;
            Vec3 vec = Utils.fraction(hit.m_82450_());
            double d = hor = Utils.isX(dir) ? vec.m_7096_() : vec.m_7094_();
            if (Utils.isPositive(dir)) {
                hor = 1.0 - hor;
            }
            Direction direction = perpDir = face == rotDir ? perpRotDir : rotDir;
            double d2 = Utils.isY(perpDir) ? vec.m_7098_() : (perpHor = Utils.isX(dir) ? vec.m_7094_() : vec.m_7096_());
            if (perpDir == Direction.DOWN || !Utils.isY(perpDir) && !Utils.isPositive(perpDir)) {
                perpHor = 1.0 - perpHor;
            }
            if (hor * 2.0 < perpHor) {
                face = dir;
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (face.m_122434_() == dir.m_122434_()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedFlatSlopePanelCornerBlock.mirrorCorner(state, mirror);
    }

    @Override
    protected Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        HorizontalRotation rotation;
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation backRot = rotation.rotate((rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION))).isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.blockFramedFlatInnerSlopePanelCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)backRot))).m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(true))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.blockFramedFlatSlopePanelCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.getOpposite()))).m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(true))));
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedFlatInverseDoubleSlopePanelCornerBlockEntity(pos, state);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            HorizontalRotation frontRot = rot.getOpposite();
            VoxelShape frontShape = Shapes.m_83113_((VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)frontRot), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)frontRot.rotate(Rotation.COUNTERCLOCKWISE_90)), (BooleanOp)BooleanOp.f_82689_).m_83216_(0.0, 0.0, 0.5);
            HorizontalRotation backRot = rot.rotate(rot.isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
            VoxelShape backShape = Shapes.m_83110_((VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)backRot), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)backRot.rotate(Rotation.COUNTERCLOCKWISE_90))).m_83216_(0.0, 0.0, 0.5);
            backShape = Utils.rotateShape(Direction.NORTH, Direction.SOUTH, backShape);
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, Shapes.m_83110_((VoxelShape)frontShape, (VoxelShape)backShape)));
        }
        return builder.build();
    }
}

