/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.data.CamoContainer;
import xfacthd.framedblocks.api.data.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedSlabBlock
extends FramedBlock {
    public FramedSlabBlock() {
        super(BlockType.FRAMED_SLAB);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.TOP, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.GLOWING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedSlabBlock.withWater(FramedSlabBlock.withTop(this.m_49966_(), context.m_43719_(), context.m_43720_()), (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ((Block)FBContent.blockFramedSlab.get()).m_5456_()) {
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            Direction face = hit.m_82434_();
            if (face == Direction.UP && !top || face == Direction.DOWN && top) {
                if (!level.m_5776_()) {
                    BlockEntity blockEntity;
                    CamoContainer camo = EmptyCamoContainer.EMPTY;
                    boolean glowing = false;
                    boolean intangible = false;
                    BlockEntity blockEntity2 = level.m_7702_(pos);
                    if (blockEntity2 instanceof FramedBlockEntity) {
                        FramedBlockEntity be = (FramedBlockEntity)blockEntity2;
                        camo = be.getCamo();
                        glowing = be.isGlowing();
                        intangible = be.isIntangible(null);
                    }
                    level.m_46597_(pos, ((Block)FBContent.blockFramedDoubleSlab.get()).m_49966_());
                    SoundType sound = ((Block)FBContent.blockFramedCube.get()).m_49962_(((Block)FBContent.blockFramedCube.get()).m_49966_());
                    level.m_5594_(null, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                        player.m_150109_().m_6596_();
                    }
                    if ((blockEntity = level.m_7702_(pos)) instanceof FramedDoubleBlockEntity) {
                        FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
                        be.setCamo(camo, top);
                        be.setGlowing(glowing);
                        be.setIntangible(intangible);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape bottomShape = FramedSlabBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape topShape = FramedSlabBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnmodifiableIterator unmodifiableIterator = states.iterator();
        while (unmodifiableIterator.hasNext()) {
            BlockState state;
            builder.put((Object)state, (Object)((Boolean)(state = (BlockState)unmodifiableIterator.next()).m_61143_((Property)FramedProperties.TOP) != false ? topShape : bottomShape));
        }
        return builder.build();
    }
}

