/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import xfacthd.framedblocks.api.util.ConTexMode;

public final class ClientConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ClientConfig INSTANCE;
    public static boolean showGhostBlocks;
    public static boolean fancyHitboxes;
    public static boolean detailedCulling;
    public static boolean useDiscreteUVSteps;
    public static ConTexMode conTexMode;
    private final ForgeConfigSpec.BooleanValue showGhostBlocksValue;
    private final ForgeConfigSpec.BooleanValue fancyHitboxesValue;
    private final ForgeConfigSpec.BooleanValue detailedCullingValue;
    private final ForgeConfigSpec.BooleanValue useDiscreteUVStepsValue;
    private final ForgeConfigSpec.EnumValue<ConTexMode> conTexModeValue;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        builder.push("general");
        this.showGhostBlocksValue = builder.comment("Wether ghost blocks are shown when you are holding a framed block").translation("config.framedblocks.showGhostBlocks").define("showGhostBlocks", true);
        this.fancyHitboxesValue = builder.comment("Wether certain framed blocks should show fancy hitboxes").translation("config.framedblocks.fancyHitboxes").define("fancyHitboxes", true);
        this.detailedCullingValue = builder.comment("If false only full block faces of framed blocks will be culled, if true all outer faces of famed blocks can be culled").translation("config.framedblocks.detailedCulling").define("detailedCulling", true);
        this.useDiscreteUVStepsValue = builder.comment("If true, the UV remapping will use discrete steps to avoid floating point errors").translation("config.framedblocks.discreteUVSteps").define("discreteUVSteps", true);
        this.conTexModeValue = builder.comment(new String[]{"Configures how detailed connected textures are supported.", "Use anything above FULL_FACE at your own risk (performance impact, unexpected behaviour)!", "If NONE, all connected textures support is disabled", "If FULL_FACE, connected textures are supported on full faces", "If FULL_CON_FACE, connected textures are supported as above and on faces whose connecting neighbor covers a full face", "If DETAILED, connected textures are supported as above and on most faces when interacting with other framed blocks"}).translation("config.framedblocks.conTexMode").defineEnum("conTexMode", (Enum)ConTexMode.FULL_FACE);
        builder.pop();
    }

    @SubscribeEvent
    public void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT && event.getConfig().getSpec() == SPEC) {
            showGhostBlocks = (Boolean)this.showGhostBlocksValue.get();
            fancyHitboxes = (Boolean)this.fancyHitboxesValue.get();
            detailedCulling = (Boolean)this.detailedCullingValue.get();
            useDiscreteUVSteps = (Boolean)this.useDiscreteUVStepsValue.get();
            conTexMode = (ConTexMode)((Object)this.conTexModeValue.get());
        }
    }

    static {
        showGhostBlocks = false;
        fancyHitboxes = false;
        detailedCulling = false;
        useDiscreteUVSteps = false;
        conTexMode = ConTexMode.FULL_FACE;
        Pair configSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (ForgeConfigSpec)configSpecPair.getRight();
        INSTANCE = (ClientConfig)configSpecPair.getLeft();
    }
}

