/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.interactive.FramedPressurePlateBlock;
import xfacthd.framedblocks.common.block.interactive.FramedWeightedPressurePlateBlock;

public class ToggleWaterloggableOverlay
implements IGuiOverlay {
    private static final ResourceLocation SYMBOL_TEXTURE = Utils.rl("textures/gui/waterloggable_symbols.png");
    public static final String MSG_IS_WATERLOGGABLE = "tooltip.framedblocks.is_waterloggable.true";
    public static final String MSG_IS_NOT_WATERLOGGABLE = "tooltip.framedblocks.is_waterloggable.false";
    public static final String MSG_MAKE_WATERLOGGABLE = "tooltip.framedblocks.make_waterloggable.true";
    public static final String MSG_MAKE_NOT_WATERLOGGABLE = "tooltip.framedblocks.make_waterloggable.false";

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        ItemStack stack = ToggleWaterloggableOverlay.player().m_21205_();
        if (!stack.m_150930_((Item)FBContent.itemFramedHammer.get())) {
            return;
        }
        BlockState state = ToggleWaterloggableOverlay.getTargettedBlock();
        if (!ToggleWaterloggableOverlay.canToggleWaterloggingOn(state.m_60734_())) {
            return;
        }
        boolean waterloggable = state.m_61138_((Property)BlockStateProperties.f_61362_);
        MutableComponent textOne = Component.m_237115_((String)(waterloggable ? MSG_IS_WATERLOGGABLE : MSG_IS_NOT_WATERLOGGABLE));
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)gui.m_93082_(), (Component)textOne, (int)(width / 2), (int)(height / 2 + 30), (int)-1);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SYMBOL_TEXTURE);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)(width / 2 - 9), (int)(height / 2 + 40), (int)0, (float)(waterloggable ? 21.0f : 1.0f), (float)1.0f, (int)18, (int)17, (int)40, (int)20);
        MutableComponent textTwo = Component.m_237115_((String)(waterloggable ? MSG_MAKE_NOT_WATERLOGGABLE : MSG_MAKE_WATERLOGGABLE));
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)gui.m_93082_(), (Component)textTwo, (int)(width / 2), (int)(height / 2 + 60), (int)-1);
    }

    private static Player player() {
        return (Player)Preconditions.checkNotNull((Object)Minecraft.m_91087_().f_91074_);
    }

    private static BlockState getTargettedBlock() {
        HitResult hit = Minecraft.m_91087_().f_91077_;
        if (hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            return ((ClientLevel)Preconditions.checkNotNull((Object)Minecraft.m_91087_().f_91073_)).m_8055_(blockHit.m_82425_());
        }
        return Blocks.f_50016_.m_49966_();
    }

    private static boolean canToggleWaterloggingOn(Block block) {
        return block instanceof FramedPressurePlateBlock || block instanceof FramedWeightedPressurePlateBlock;
    }
}

