/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedSlopePanelModel
extends FramedBlockModel {
    public static final float SLOPE_ANGLE = (float)Math.toDegrees(Math.atan(0.5));
    private final Direction facing;
    private final HorizontalRotation rotation;
    private final Direction orientation;
    private final boolean front;

    public FramedSlopePanelModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        this.orientation = this.rotation.withFacing(this.facing);
        this.front = (Boolean)state.m_61143_((Property)PropertyHolder.FRONT);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        boolean yAxis = Utils.isY(this.orientation);
        if (face == this.orientation.m_122424_()) {
            Direction cutDir;
            Direction direction = cutDir = this.front ? this.facing : this.facing.m_122424_();
            if (Utils.isY(this.orientation)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(cutDir, 0.5f)).export(quadMap.get(face));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(face));
            }
        } else if (face == this.facing.m_122424_()) {
            QuadModifier.geometry(quad).apply(FramedSlopePanelModel.createSlope(this.facing, this.orientation)).applyIf(Modifiers.offset(this.facing, 0.5f), !this.front).export(quadMap.get(null));
        } else if (face == this.facing) {
            if (this.front) {
                QuadModifier.geometry(quad).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
        } else if (face != this.orientation) {
            if (yAxis) {
                float top;
                boolean up;
                boolean bl = up = this.orientation == Direction.UP;
                float f = up ? (this.front ? 0.5f : 0.0f) : (top = this.front ? 1.0f : 0.5f);
                float bottom = up ? (this.front ? 1.0f : 0.5f) : (this.front ? 0.5f : 0.0f);
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122424_(), top, bottom)).applyIf(Modifiers.cutSideLeftRight(this.facing, 0.5f), this.front).export(quadMap.get(face));
            } else {
                float right;
                boolean rightRot;
                boolean bl = rightRot = this.rotation == HorizontalRotation.RIGHT;
                float f = rightRot ? (this.front ? 1.0f : 0.5f) : (right = this.front ? 0.5f : 0.0f);
                float left = rightRot ? (this.front ? 0.5f : 0.0f) : (this.front ? 1.0f : 0.5f);
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), right, left)).applyIf(Modifiers.cutTopBottom(this.facing, 0.5f), this.front).export(quadMap.get(face));
            }
        }
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemTransforms.TransformType type) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }

    public static QuadModifier.Modifier createSlope(Direction facing, Direction orientation) {
        Preconditions.checkArgument((facing.m_122434_() != orientation.m_122434_() ? 1 : 0) != 0, (Object)"Directions must be perpendicular");
        if (Utils.isY(orientation)) {
            return Modifiers.makeVerticalSlope(orientation == Direction.UP, SLOPE_ANGLE);
        }
        return Modifiers.makeHorizontalSlope(orientation == facing.m_122428_(), SLOPE_ANGLE);
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedSlopePanel.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

