/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedExtendedSlopePanelModel
extends FramedBlockModel {
    private final Direction facing;
    private final HorizontalRotation rotation;
    private final Direction orientation;

    public FramedExtendedSlopePanelModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        this.orientation = this.rotation.withFacing(this.facing);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        boolean yAxis = Utils.isY(this.orientation);
        if (face == this.orientation) {
            if (Utils.isY(this.orientation)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), 0.5f)).export(quadMap.get(face));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122424_(), 0.5f)).export(quadMap.get(face));
            }
        } else if (face == this.facing.m_122424_()) {
            QuadModifier.geometry(quad).apply(FramedSlopePanelModel.createSlope(this.facing, this.orientation)).export(quadMap.get(null));
        } else if (face.m_122434_() != this.facing.m_122434_() && face.m_122434_() != this.orientation.m_122434_()) {
            if (yAxis) {
                boolean up = this.orientation == Direction.UP;
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122424_(), up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).export(quadMap.get(face));
            } else {
                boolean rightRot = this.rotation == HorizontalRotation.RIGHT;
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), rightRot ? 1.0f : 0.5f, rightRot ? 0.5f : 1.0f)).export(quadMap.get(face));
            }
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedExtendedSlopePanel.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

