/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.common.FBContent;

public class FramedInnerThreewayCornerModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;

    public FramedInnerThreewayCornerModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (quadDir == Direction.DOWN && this.top || quadDir == Direction.UP && !this.top) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.dir.m_122424_(), 1.0f, 0.0f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.dir.m_122427_() || quadDir == this.dir.m_122424_()) {
            Direction cutDir = quadDir == this.dir.m_122424_() ? this.dir.m_122427_() : this.dir.m_122424_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(cutDir, this.top ? 1.0f : 0.0f, this.top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
        }
        if (quadDir == this.dir.m_122427_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.dir)).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.top ? Direction.UP : Direction.DOWN)).apply(Modifiers.makeHorizontalSlope(true, 45.0f)).export(quadMap.get(null));
        } else if (quadDir == this.dir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.dir.m_122428_())).apply(Modifiers.makeVerticalSlope(!this.top, 45.0f)).export(quadMap.get(null));
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedInnerThreewayCorner.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

