/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FramedPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction.Axis axis;

    public FramedPrismModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        this.axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadFace = quad.m_111306_();
        if (this.isStateInvalid()) {
            quadMap.get(quadFace).add(quad);
            return;
        }
        if (Utils.isY(this.facing) && quadFace.m_122434_() != this.axis && quadFace.m_122434_() != this.facing.m_122434_()) {
            boolean up = this.facing == Direction.UP;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(!up, 0.5f)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
        } else if (!Utils.isY(this.facing) && this.axis == Direction.Axis.Y && quadFace.m_122434_() != this.axis && quadFace.m_122434_() != this.facing.m_122434_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing, 0.5f)).apply(Modifiers.makeHorizontalSlope(quadFace == this.facing.m_122428_(), 45.0f)).export(quadMap.get(null));
        } else if (!Utils.isY(this.facing) && this.axis != Direction.Axis.Y && quadFace == this.facing) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
        } else if (quadFace.m_122434_() == this.axis) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.facing)).export(quadMap.get(quadFace));
        }
    }

    private boolean isStateInvalid() {
        return this.axis == this.facing.m_122434_();
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemTransforms.TransformType type) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedPrism.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP);
    }
}

