/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedInnerSlopedPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction orientation;

    public FramedInnerSlopedPrismModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        this.orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadFace = quad.m_111306_();
        if (this.isStateInvalid()) {
            quadMap.get(quadFace).add(quad);
            return;
        }
        if (Utils.isY(this.facing) && quadFace.m_122434_() != this.orientation.m_122434_() && quadFace.m_122434_() != this.facing.m_122434_()) {
            boolean up = this.facing == Direction.UP;
            float top = up ? 1.0f : 0.0f;
            float bottom = up ? 0.0f : 1.0f;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(up, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.m_122424_(), top, bottom)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
        } else if (!Utils.isY(this.facing) && Utils.isY(this.orientation) && quadFace.m_122434_() != this.orientation.m_122434_() && quadFace.m_122434_() != this.facing.m_122434_()) {
            boolean down = this.orientation == Direction.UP;
            boolean cw = quadFace == this.facing.m_122427_();
            float right = cw ? 0.0f : 1.0f;
            float left = cw ? 1.0f : 0.0f;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122424_(), 0.5f)).apply(Modifiers.cutSideUpDown(down, right, left)).apply(Modifiers.makeHorizontalSlope(quadFace == this.facing.m_122428_(), 45.0f)).export(quadMap.get(null));
        } else if (!Utils.isY(this.facing) && !Utils.isY(this.orientation) && quadFace == this.facing) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.m_122424_(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.orientation.m_122424_(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
            boolean right = this.orientation == this.facing.m_122427_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.orientation, 0.5f)).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeHorizontalSlope(right, 45.0f)).export(quadMap.get(null));
        } else if (!Utils.isY(this.facing) && Utils.isY(this.orientation) && quadFace == this.facing) {
            boolean up = this.orientation == Direction.UP;
            QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.orientation)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
        } else if (quadFace == this.orientation) {
            if (Utils.isY(this.orientation)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122427_(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122428_(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
            } else if (Utils.isY(this.facing)) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadFace.m_122427_(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadFace.m_122428_(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                boolean up = this.facing == Direction.UP;
                QuadModifier.geometry(quad).apply(Modifiers.cutSmallTriangle(this.facing.m_122424_())).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
            }
        }
    }

    private boolean isStateInvalid() {
        return this.orientation.m_122434_() == this.facing.m_122434_();
    }

    @Override
    protected boolean transformAllQuads(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        Direction orientation = (Direction)state.m_61143_((Property)PropertyHolder.ORIENTATION);
        return Utils.isY(facing) || Utils.isY(orientation);
    }

    public static BlockState itemSource() {
        return (BlockState)((BlockState)((Block)FBContent.blockFramedInnerSlopedPrism.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP)).m_61124_((Property)PropertyHolder.ORIENTATION, (Comparable)Direction.EAST);
    }
}

