/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.NotNull;
import xfacthd.framedblocks.api.model.BakedModelProxy;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;

public class FramedDoubleBlockModel
extends BakedModelProxy {
    private final boolean specialItemModel;
    private final Tuple<BlockState, BlockState> dummyStates;
    private Tuple<BakedModel, BakedModel> models = null;

    public FramedDoubleBlockModel(BlockState state, BakedModel baseModel, boolean specialItemModel) {
        super(baseModel);
        this.dummyStates = AbstractFramedDoubleBlock.getStatePair(state);
        this.specialItemModel = specialItemModel;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType layer) {
        ArrayList<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(2);
        Tuple<BakedModel, BakedModel> models = this.getModels();
        ModelData dataLeft = (ModelData)extraData.get(FramedDoubleBlockEntity.DATA_LEFT);
        quads.add(((BakedModel)models.m_14418_()).getQuads((BlockState)this.dummyStates.m_14418_(), side, rand, dataLeft != null ? dataLeft : ModelData.EMPTY, layer));
        ModelData dataRight = (ModelData)extraData.get(FramedDoubleBlockEntity.DATA_RIGHT);
        quads.add(FramedDoubleBlockModel.invertTintIndizes(((BakedModel)models.m_14419_()).getQuads((BlockState)this.dummyStates.m_14419_(), side, rand, dataRight != null ? dataRight : ModelData.EMPTY, layer)));
        return ConcatenatedListView.of(quads);
    }

    @Override
    public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
        if (this.specialItemModel) {
            Tuple<BakedModel, BakedModel> models = this.getModels();
            ArrayList<List> quads = new ArrayList<List>(2);
            quads.add(((BakedModel)models.m_14418_()).m_213637_((BlockState)this.dummyStates.m_14418_(), side, rand));
            quads.add(((BakedModel)models.m_14419_()).m_213637_((BlockState)this.dummyStates.m_14419_(), side, rand));
            return ConcatenatedListView.of(quads);
        }
        return super.m_213637_(state, side, rand);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        FramedBlockData fbData;
        ModelData innerData = (ModelData)data.get(FramedDoubleBlockEntity.DATA_LEFT);
        if (innerData != null && (fbData = (FramedBlockData)innerData.get(FramedBlockData.PROPERTY)) != null && !fbData.getCamoState().m_60795_()) {
            return ((BakedModel)this.getModels().m_14418_()).getParticleIcon(innerData);
        }
        innerData = (ModelData)data.get(FramedDoubleBlockEntity.DATA_RIGHT);
        if (innerData != null && (fbData = (FramedBlockData)innerData.get(FramedBlockData.PROPERTY)) != null && !fbData.getCamoState().m_60795_()) {
            return ((BakedModel)this.getModels().m_14419_()).getParticleIcon(innerData);
        }
        return this.baseModel.m_6160_();
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        Tuple<BakedModel, BakedModel> models = this.getModels();
        ModelData dataLeft = (ModelData)data.get(FramedDoubleBlockEntity.DATA_LEFT);
        ModelData dataRight = (ModelData)data.get(FramedDoubleBlockEntity.DATA_RIGHT);
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{((BakedModel)models.m_14418_()).getRenderTypes((BlockState)this.dummyStates.m_14418_(), rand, dataLeft != null ? dataLeft : ModelData.EMPTY), ((BakedModel)models.m_14419_()).getRenderTypes((BlockState)this.dummyStates.m_14419_(), rand, dataRight != null ? dataRight : ModelData.EMPTY)});
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        Tuple<BakedModel, BakedModel> models = this.getModels();
        ModelData dataLeft = (ModelData)tileData.get(FramedDoubleBlockEntity.DATA_LEFT);
        ModelData dataRight = (ModelData)tileData.get(FramedDoubleBlockEntity.DATA_RIGHT);
        dataLeft = ((BakedModel)models.m_14418_()).getModelData(level, pos, (BlockState)this.dummyStates.m_14418_(), dataLeft != null ? dataLeft : ModelData.EMPTY);
        dataRight = ((BakedModel)models.m_14419_()).getModelData(level, pos, (BlockState)this.dummyStates.m_14419_(), dataRight != null ? dataRight : ModelData.EMPTY);
        return tileData.derive().with(FramedDoubleBlockEntity.DATA_LEFT, (Object)dataLeft).with(FramedDoubleBlockEntity.DATA_RIGHT, (Object)dataRight).build();
    }

    protected final Tuple<BakedModel, BakedModel> getModels() {
        if (this.models == null) {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            this.models = new Tuple((Object)dispatcher.m_110910_((BlockState)this.dummyStates.m_14418_()), (Object)dispatcher.m_110910_((BlockState)this.dummyStates.m_14419_()));
        }
        return this.models;
    }

    protected final TextureAtlasSprite getSpriteOrDefault(ModelData data, ModelProperty<ModelData> key, BakedModel model) {
        FramedBlockData fbData;
        ModelData innerData = (ModelData)data.get(key);
        if (innerData != null && (fbData = (FramedBlockData)innerData.get(FramedBlockData.PROPERTY)) != null && !fbData.getCamoState().m_60795_()) {
            return model.getParticleIcon(innerData);
        }
        return this.baseModel.m_6160_();
    }

    private static List<BakedQuad> invertTintIndizes(List<BakedQuad> quads) {
        ArrayList<BakedQuad> inverted = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            inverted.add(ModelUtils.invertTintIndex(quad));
        }
        return inverted;
    }
}

