/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util.client;

import com.google.common.base.Preconditions;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.api.util.client.TriangleDirection;

@Deprecated(forRemoval=true, since="1.19")
public final class BakedQuadTransformer {
    private static final float SCALE_ROTATION_45 = 1.0f / (float)Math.cos(0.7853981633974483) - 1.0f;
    private static final float SCALE_ROTATION_22_5 = 1.0f / (float)Math.cos(0.39269908169872414) - 1.0f;
    private static final float PRISM_TILT_ANGLE = (float)Math.toDegrees(Math.atan(0.5));
    private static final Vector3f ONE = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3f HALF = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final Vector3f[] DIR_TO_ORIGIN_VECS = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)};

    public static void createTopBottomSlopeQuad(BakedQuad quad, boolean up) {
        ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            Direction dir = quad.m_111306_();
            int idx = Utils.isX(dir) ? 0 : 2;
            boolean invert = Utils.isPositive(dir) == up;
            pos[1][idx] = invert ? 1.0f - pos[1][1] : pos[1][1];
            pos[2][idx] = invert ? 1.0f - pos[2][1] : pos[2][1];
            pos[0][idx] = invert ? 1.0f - pos[0][1] : pos[0][1];
            pos[3][idx] = invert ? 1.0f - pos[3][1] : pos[3][1];
            return true;
        });
    }

    public static void createSideSlopeQuad(BakedQuad quad, boolean rightEdge) {
        ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            Direction dir = quad.m_111306_();
            boolean xAxis = Utils.isX(dir);
            boolean invert = Utils.isZ(dir) == rightEdge;
            int srcCoord = xAxis ? 2 : 0;
            int destCoord = xAxis ? 0 : 2;
            pos[0][destCoord] = invert ? 1.0f - pos[0][srcCoord] : pos[0][srcCoord];
            pos[1][destCoord] = invert ? 1.0f - pos[1][srcCoord] : pos[1][srcCoord];
            pos[3][destCoord] = invert ? 1.0f - pos[3][srcCoord] : pos[3][srcCoord];
            pos[2][destCoord] = invert ? 1.0f - pos[2][srcCoord] : pos[2][srcCoord];
            return true;
        });
    }

    public static boolean createSideTriangleQuad(BakedQuad quad, boolean rightSide, boolean top) {
        return BakedQuadTransformer.createSideTriangleQuad(quad, rightSide, top, 1.0f, 0.0f);
    }

    public static boolean createSideTriangleQuad(BakedQuad quad, boolean rightSide, boolean top, float height, float baseOffset) {
        return ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            float xz;
            boolean neg;
            int idxTopFront = rightSide ? 0 : 3;
            int idxBotFront = rightSide ? 1 : 2;
            int idxTopBack = rightSide ? 3 : 0;
            int idxBotBack = rightSide ? 2 : 1;
            int idxTargetFront = top ? idxBotFront : idxTopFront;
            int idxTargetBack = top ? idxBotBack : idxTopBack;
            Direction dir = rightSide ? quad.m_111306_().m_122428_() : quad.m_111306_().m_122427_();
            boolean xAxis = Utils.isX(dir);
            boolean bl = neg = !Utils.isPositive(dir);
            float f = xAxis ? pos[top ? idxTopBack : idxBotBack][0] : (xz = pos[top ? idxTopBack : idxBotBack][2]);
            if (neg) {
                xz = 1.0f - xz;
            }
            float heightOffset = 1.0f - height;
            if (top && pos[idxTopBack][1] >= 1.0f - (xz + baseOffset - heightOffset) || !top && pos[idxBotBack][1] <= xz + baseOffset - heightOffset) {
                float[][] uvSrc = new float[4][2];
                for (int i = 0; i < 4; ++i) {
                    System.arraycopy(uv[i], 0, uvSrc[i], 0, 2);
                }
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                float f2 = xz = xAxis ? pos[idxBotFront][0] : pos[idxBotFront][2];
                if (neg) {
                    xz = 1.0f - xz;
                }
                float toY = top ? Math.min(Math.max(pos[idxBotFront][1], 1.0f - xz), pos[idxTopFront][1]) : Math.max(Math.min(pos[idxTopFront][1], xz -= heightOffset), pos[idxBotFront][1]);
                ModelUtils.remapUV(quad.m_111306_(), pos[idxBotFront][1], pos[idxTopFront][1], toY += top ? -baseOffset : baseOffset, uvSrc, uv, idxTopFront, idxBotFront, idxTargetFront, true, true, rotated, mirrored);
                pos[idxTargetFront][1] = toY;
                float f3 = xz = xAxis ? pos[idxBotBack][0] : pos[idxBotBack][2];
                if (neg) {
                    xz = 1.0f - xz;
                }
                toY = top ? Math.min(Math.max(pos[idxBotBack][1], 1.0f - xz), pos[idxTopBack][1]) : Math.max(Math.min(pos[idxTopBack][1], xz -= heightOffset), pos[idxBotBack][1]);
                ModelUtils.remapUV(quad.m_111306_(), pos[idxTopBack][1], pos[idxBotBack][1], toY += top ? -baseOffset : baseOffset, uvSrc, uv, idxTopBack, idxBotBack, idxTargetBack, true, true, rotated, mirrored);
                pos[idxTargetBack][1] = toY;
                return true;
            }
            return false;
        });
    }

    public static boolean createVerticalSideTriangleQuad(BakedQuad quad, boolean rightSide, boolean top, float depth, float baseOffset) {
        Direction dir = rightSide ? quad.m_111306_().m_122427_() : quad.m_111306_().m_122428_();
        return BakedQuadTransformer.createVerticalSideQuad(quad, dir, top ? depth : baseOffset, !top ? depth : baseOffset);
    }

    public static boolean createTopBottomTriangleQuad(BakedQuad quad, Direction dir) {
        return ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            block10: {
                int idxToLeft;
                int idxToRight;
                int idxFromLeft;
                int idxFromRight;
                int coordModifier;
                int coordTarget;
                boolean negModifier;
                boolean negTarget;
                boolean up;
                boolean xAxis;
                block9: {
                    xAxis = Utils.isX(dir);
                    up = quad.m_111306_() == Direction.UP;
                    negTarget = !Utils.isPositive(dir);
                    negModifier = !Utils.isPositive(dir.m_122427_());
                    coordTarget = xAxis ? 0 : 2;
                    coordModifier = xAxis ? 2 : 0;
                    idxFromRight = xAxis ? dir.m_122424_().m_122416_() : dir.m_122416_();
                    idxFromLeft = xAxis ? dir.m_122427_().m_122416_() : dir.m_122428_().m_122416_();
                    idxToRight = xAxis ? dir.m_122428_().m_122416_() : dir.m_122427_().m_122416_();
                    int n = idxToLeft = !xAxis ? dir.m_122424_().m_122416_() : dir.m_122416_();
                    if (!up && !xAxis) {
                        int temp = idxFromLeft;
                        idxFromLeft = idxToLeft;
                        idxToLeft = temp;
                        temp = idxFromRight;
                        idxFromRight = idxToRight;
                        idxToRight = temp;
                    }
                    float x = pos[idxToLeft][0];
                    if (xAxis && negTarget || !xAxis && negModifier) {
                        x = 1.0f - x;
                    }
                    float z = pos[idxToLeft][2];
                    if (!xAxis && negTarget || xAxis && negModifier) {
                        z = 1.0f - z;
                    }
                    if (xAxis && (!up ? x >= z : x > z)) break block9;
                    if (xAxis || !(z > x)) break block10;
                }
                float[][] uvSrc = new float[4][2];
                for (int i = 0; i < 4; ++i) {
                    System.arraycopy(uv[i], 0, uvSrc[i], 0, 2);
                }
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                float mod = pos[idxFromLeft][coordModifier];
                if (negModifier) {
                    mod = 1.0f - mod;
                }
                float xz = pos[idxFromLeft][coordTarget];
                float toXZ = negTarget ? Math.min(xz, Math.max(pos[idxToLeft][coordTarget], 1.0f - mod)) : Math.max(xz, Math.min(pos[idxToLeft][coordTarget], mod));
                ModelUtils.remapUV(quad.m_111306_(), xz, pos[idxToLeft][coordTarget], toXZ, uvSrc, uv, idxFromLeft, idxToLeft, idxFromLeft, !xAxis, !xAxis && !up, rotated, mirrored);
                pos[idxFromLeft][coordTarget] = toXZ;
                mod = pos[idxFromRight][coordModifier];
                if (negModifier) {
                    mod = 1.0f - mod;
                }
                xz = pos[idxFromRight][coordTarget];
                toXZ = negTarget ? Math.min(xz, Math.max(pos[idxToRight][coordTarget], 1.0f - mod)) : Math.max(xz, Math.min(pos[idxToRight][coordTarget], mod));
                ModelUtils.remapUV(quad.m_111306_(), xz, pos[idxToRight][coordTarget], toXZ, uvSrc, uv, idxFromRight, idxToRight, idxFromRight, !xAxis, !xAxis && !up, rotated, mirrored);
                pos[idxFromRight][coordTarget] = toXZ;
                return true;
            }
            return false;
        });
    }

    public static boolean createTopBottomTriangleQuad(BakedQuad quad, Direction dir, boolean right, float depth, float baseOffset) {
        Direction face = quad.m_111306_();
        if (face == Direction.UP && !Utils.isPositive(dir) || face == Direction.DOWN && Utils.isPositive(dir.m_122427_())) {
            right = !right;
        }
        return BakedQuadTransformer.createTopBottomQuad(quad, dir, right ? depth : baseOffset, right ? baseOffset : depth);
    }

    public static boolean createPrismTriangleQuad(BakedQuad quad, boolean up, boolean back) {
        float angle;
        boolean useQuad = ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            float xz2;
            int coord = Utils.isX(quad.m_111306_()) ? 2 : 0;
            int checkVert1 = up ? 2 : 3;
            int checkVert2 = up ? 1 : 0;
            boolean vertPos = Utils.isPositive(quad.m_111306_().m_122428_());
            float h1 = (up ? pos[checkVert1][1] : 1.0f - pos[checkVert1][1]) / 2.0f;
            float h2 = 1.0f - (up ? pos[checkVert2][1] : 1.0f - pos[checkVert2][1]) / 2.0f;
            float xz1 = vertPos ? pos[checkVert1][coord] : 1.0f - pos[checkVert1][coord];
            float f = xz2 = vertPos ? pos[checkVert2][coord] : 1.0f - pos[checkVert2][coord];
            if (xz1 >= h1 && xz2 <= h2) {
                boolean northeast = quad.m_111306_() == Direction.NORTH || quad.m_111306_() == Direction.EAST;
                int idxTip1 = up ? 0 : 1;
                int idxTip2 = up ? 3 : 2;
                int idxBase1 = up ? 1 : 0;
                int idxBase2 = up ? 2 : 3;
                float yTip1 = (up ? pos[idxTip1][1] : 1.0f - pos[idxTip1][1]) / 2.0f;
                float yTip2 = (up ? pos[idxTip2][1] : 1.0f - pos[idxTip2][1]) / 2.0f;
                float yBase1 = (up ? pos[idxBase1][1] : 1.0f - pos[idxBase1][1]) / 2.0f;
                float yBase2 = (up ? pos[idxBase2][1] : 1.0f - pos[idxBase2][1]) / 2.0f;
                if (northeast) {
                    yTip1 = 1.0f - yTip1;
                    yBase1 = 1.0f - yBase1;
                } else {
                    yTip2 = 1.0f - yTip2;
                    yBase2 = 1.0f - yBase2;
                }
                yTip1 = northeast ? Math.min(yTip1, pos[idxTip1][coord]) : Math.max(yTip1, pos[idxTip1][coord]);
                yTip2 = northeast ? Math.max(yTip2, pos[idxTip2][coord]) : Math.min(yTip2, pos[idxTip2][coord]);
                yBase1 = northeast ? Math.min(yBase1, pos[idxBase1][coord]) : Math.max(yBase1, pos[idxBase1][coord]);
                yBase2 = northeast ? Math.max(yBase2, pos[idxBase2][coord]) : Math.min(yBase2, pos[idxBase2][coord]);
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                float[][] uvSrc = new float[4][2];
                for (int i = 0; i < 4; ++i) {
                    System.arraycopy(uv[i], 0, uvSrc[i], 0, 2);
                }
                ModelUtils.remapUV(quad.m_111306_(), pos[idxTip1][coord], pos[idxTip2][coord], yTip1, uvSrc, uv, idxTip1, idxTip2, idxTip1, false, northeast, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[idxTip1][coord], pos[idxTip2][coord], yTip2, uvSrc, uv, idxTip1, idxTip2, idxTip2, false, northeast, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[idxBase1][coord], pos[idxBase2][coord], yBase1, uvSrc, uv, idxBase1, idxBase2, idxBase1, false, northeast, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[idxBase1][coord], pos[idxBase2][coord], yBase2, uvSrc, uv, idxBase1, idxBase2, idxBase2, false, northeast, rotated, mirrored);
                pos[idxTip1][coord] = yTip1;
                pos[idxTip2][coord] = yTip2;
                pos[idxBase1][coord] = yBase1;
                pos[idxBase2][coord] = yBase2;
                return true;
            }
            return false;
        });
        if (!useQuad) {
            return false;
        }
        Vector3f origin = DIR_TO_ORIGIN_VECS[quad.m_111306_().ordinal() - 2 + (up ? 0 : 4)];
        boolean northeast = quad.m_111306_() == Direction.NORTH || quad.m_111306_() == Direction.EAST;
        float f = angle = back ? PRISM_TILT_ANGLE : -PRISM_TILT_ANGLE;
        if (northeast != up) {
            angle *= -1.0f;
        }
        BakedQuadTransformer.rotateQuadAroundAxis(quad, quad.m_111306_().m_122427_().m_122434_(), origin, angle, true);
        BakedQuadTransformer.rotateQuadAroundAxis(quad, Direction.Axis.Y, origin, 45.0f, true);
        return true;
    }

    public static boolean createSmallTriangleQuad(BakedQuad quad, TriangleDirection dir) {
        if (dir.isVertical()) {
            if (!BakedQuadTransformer.createHorizontalSideQuad(quad, dir == TriangleDirection.DOWN, 0.5f)) {
                return false;
            }
        } else {
            Direction cutDir;
            Direction direction = cutDir = dir == TriangleDirection.RIGHT ? quad.m_111306_().m_122428_() : quad.m_111306_().m_122427_();
            if (!BakedQuadTransformer.createVerticalSideQuad(quad, cutDir, 0.5f)) {
                return false;
            }
        }
        ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            Direction perpDir = quad.m_111306_().m_122428_();
            boolean perpPos = Utils.isPositive(perpDir);
            boolean perpXAxis = Utils.isX(perpDir);
            boolean rotated = ModelUtils.isQuadRotated(uv);
            boolean mirrored = ModelUtils.isQuadMirrored(uv);
            float[][] uvSrc = new float[4][2];
            for (int i = 0; i < 4; ++i) {
                System.arraycopy(uv[i], 0, uvSrc[i], 0, 2);
            }
            if (dir.isVertical()) {
                boolean up = dir == TriangleDirection.UP;
                int coordTarget = perpXAxis ? 0 : 2;
                float y0 = up ? pos[0][1] : 1.0f - pos[0][1];
                float y1 = up ? pos[1][1] : 1.0f - pos[1][1];
                float y2 = up ? 1.0f - pos[2][1] : pos[2][1];
                float y3 = up ? 1.0f - pos[3][1] : pos[3][1];
                float xz0 = perpPos ? Math.max(Math.min(y0, pos[3][coordTarget]), pos[0][coordTarget]) : Math.min(Math.max(1.0f - y0, pos[3][coordTarget]), pos[0][coordTarget]);
                float xz1 = perpPos ? Math.max(Math.min(y1, pos[2][coordTarget]), pos[1][coordTarget]) : Math.min(Math.max(1.0f - y1, pos[2][coordTarget]), pos[1][coordTarget]);
                float xz2 = perpPos ? Math.min(Math.max(y2, pos[1][coordTarget]), pos[2][coordTarget]) : Math.max(Math.min(1.0f - y2, pos[1][coordTarget]), pos[2][coordTarget]);
                float xz3 = perpPos ? Math.min(Math.max(y3, pos[0][coordTarget]), pos[3][coordTarget]) : Math.max(Math.min(1.0f - y3, pos[0][coordTarget]), pos[3][coordTarget]);
                ModelUtils.remapUV(quad.m_111306_(), pos[0][coordTarget], pos[3][coordTarget], xz0, uvSrc, uv, 0, 3, 0, false, !perpPos, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[1][coordTarget], pos[2][coordTarget], xz1, uvSrc, uv, 1, 2, 1, false, !perpPos, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[1][coordTarget], pos[2][coordTarget], xz2, uvSrc, uv, 1, 2, 2, false, !perpPos, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[0][coordTarget], pos[3][coordTarget], xz3, uvSrc, uv, 0, 3, 3, false, !perpPos, rotated, mirrored);
                pos[0][coordTarget] = xz0;
                pos[1][coordTarget] = xz1;
                pos[2][coordTarget] = xz2;
                pos[3][coordTarget] = xz3;
            } else {
                boolean right = dir == TriangleDirection.RIGHT;
                int coordSource = perpXAxis ? 0 : 2;
                float xz0 = right == perpPos ? 1.0f - pos[0][coordSource] : pos[0][coordSource];
                float xz1 = right == perpPos ? pos[1][coordSource] : 1.0f - pos[1][coordSource];
                float xz2 = right == perpPos ? pos[2][coordSource] : 1.0f - pos[2][coordSource];
                float xz3 = right == perpPos ? 1.0f - pos[3][coordSource] : pos[3][coordSource];
                float y0 = Math.min(Math.max(xz0, pos[1][1]), pos[0][1]);
                float y1 = Math.max(Math.min(xz1, pos[0][1]), pos[1][1]);
                float y2 = Math.max(Math.min(xz2, pos[3][1]), pos[2][1]);
                float y3 = Math.min(Math.max(xz3, pos[2][1]), pos[3][1]);
                ModelUtils.remapUV(quad.m_111306_(), pos[0][1], pos[1][1], y0, uvSrc, uv, 0, 1, 0, true, true, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[0][1], pos[1][1], y1, uvSrc, uv, 0, 1, 1, true, true, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[2][1], pos[3][1], y2, uvSrc, uv, 2, 3, 2, true, true, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[2][1], pos[3][1], y3, uvSrc, uv, 2, 3, 3, true, true, rotated, mirrored);
                pos[0][1] = y0;
                pos[1][1] = y1;
                pos[2][1] = y2;
                pos[3][1] = y3;
            }
            return true;
        });
        return true;
    }

    public static boolean createTopBottomSmallTriangleQuad(BakedQuad quad, Direction dir) {
        if (!BakedQuadTransformer.createTopBottomQuad(quad, dir, 0.5f)) {
            return false;
        }
        return ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            boolean dirPos = Utils.isPositive(dir);
            boolean xAxis = Utils.isX(dir);
            boolean rotated = ModelUtils.isQuadRotated(uv);
            boolean mirrored = ModelUtils.isQuadMirrored(uv);
            int coordSource = xAxis ? 0 : 2;
            int coordTarget = xAxis ? 2 : 0;
            float[][] uvSrc = new float[4][2];
            for (int i = 0; i < 4; ++i) {
                System.arraycopy(uv[i], 0, uvSrc[i], 0, 2);
            }
            if (xAxis) {
                float xz0Src = dirPos ? 1.0f - pos[0][coordSource] : pos[0][coordSource];
                float xz1Src = dirPos ? pos[1][coordSource] : 1.0f - pos[1][coordSource];
                float xz2Src = dirPos ? pos[2][coordSource] : 1.0f - pos[2][coordSource];
                float xz3Src = dirPos ? 1.0f - pos[3][coordSource] : pos[3][coordSource];
                boolean up = quad.m_111306_() == Direction.UP;
                float xz0 = up ? Math.max(Math.min(1.0f - xz0Src, pos[1][coordTarget]), pos[0][coordTarget]) : Math.min(Math.max(xz0Src, pos[1][coordTarget]), pos[0][coordTarget]);
                float xz1 = up ? Math.min(Math.max(1.0f - xz1Src, pos[0][coordTarget]), pos[1][coordTarget]) : Math.max(Math.min(xz1Src, pos[0][coordTarget]), pos[1][coordTarget]);
                float xz2 = up ? Math.min(Math.max(1.0f - xz2Src, pos[3][coordTarget]), pos[2][coordTarget]) : Math.max(Math.min(xz2Src, pos[3][coordTarget]), pos[2][coordTarget]);
                float xz3 = up ? Math.max(Math.min(1.0f - xz3Src, pos[2][coordTarget]), pos[3][coordTarget]) : Math.min(Math.max(xz3Src, pos[2][coordTarget]), pos[3][coordTarget]);
                ModelUtils.remapUV(quad.m_111306_(), pos[0][coordTarget], pos[1][coordTarget], xz0, uvSrc, uv, 0, 1, 0, true, false, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[0][coordTarget], pos[1][coordTarget], xz1, uvSrc, uv, 0, 1, 1, true, false, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[2][coordTarget], pos[3][coordTarget], xz2, uvSrc, uv, 2, 3, 2, true, false, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[2][coordTarget], pos[3][coordTarget], xz3, uvSrc, uv, 2, 3, 3, true, false, rotated, mirrored);
                pos[0][coordTarget] = xz0;
                pos[1][coordTarget] = xz1;
                pos[2][coordTarget] = xz2;
                pos[3][coordTarget] = xz3;
            } else {
                float xz0Src = dirPos ? pos[0][coordSource] : 1.0f - pos[0][coordSource];
                float xz1Src = dirPos ? pos[1][coordSource] : 1.0f - pos[1][coordSource];
                float xz2Src = dirPos ? 1.0f - pos[2][coordSource] : pos[2][coordSource];
                float xz3Src = dirPos ? 1.0f - pos[3][coordSource] : pos[3][coordSource];
                float xz0 = Math.max(Math.min(xz0Src, pos[3][coordTarget]), pos[0][coordTarget]);
                float xz1 = Math.max(Math.min(xz1Src, pos[2][coordTarget]), pos[1][coordTarget]);
                float xz2 = Math.min(Math.max(xz2Src, pos[1][coordTarget]), pos[2][coordTarget]);
                float xz3 = Math.min(Math.max(xz3Src, pos[0][coordTarget]), pos[3][coordTarget]);
                ModelUtils.remapUV(quad.m_111306_(), pos[0][coordTarget], pos[3][coordTarget], xz0, uvSrc, uv, 0, 3, 0, false, true, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[1][coordTarget], pos[2][coordTarget], xz1, uvSrc, uv, 1, 2, 1, false, true, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[1][coordTarget], pos[2][coordTarget], xz2, uvSrc, uv, 1, 2, 2, false, true, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[0][coordTarget], pos[3][coordTarget], xz3, uvSrc, uv, 0, 3, 3, false, true, rotated, mirrored);
                pos[0][coordTarget] = xz0;
                pos[1][coordTarget] = xz1;
                pos[2][coordTarget] = xz2;
                pos[3][coordTarget] = xz3;
            }
            return true;
        });
    }

    public static boolean createHorizontalSideQuad(BakedQuad quad, boolean fromTop, float height) {
        return BakedQuadTransformer.createHorizontalSideQuad(quad, fromTop, height, height);
    }

    public static boolean createHorizontalSideQuad(BakedQuad quad, boolean fromTop, float heightR, float heightL) {
        return ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            float factorR;
            Direction quadDirRot = quad.m_111306_().m_122428_();
            boolean x = Utils.isX(quadDirRot);
            boolean positive = Utils.isPositive(quadDirRot);
            float f = positive ? pos[0][x ? 0 : 2] : (factorR = 1.0f - pos[0][x ? 0 : 2]);
            float factorL = positive ? pos[3][x ? 0 : 2] : 1.0f - pos[3][x ? 0 : 2];
            float targetR = Mth.m_14179_((float)factorR, (float)(fromTop ? 1.0f - heightR : heightR), (float)(fromTop ? 1.0f - heightL : heightL));
            float targetL = Mth.m_14179_((float)factorL, (float)(fromTop ? 1.0f - heightR : heightR), (float)(fromTop ? 1.0f - heightL : heightL));
            if (fromTop && pos[0][1] >= targetR && pos[3][1] >= targetL || !fromTop && pos[1][1] <= targetR && pos[2][1] <= targetL) {
                int idx1 = fromTop ? 1 : 0;
                int idx2 = fromTop ? 2 : 3;
                float y1 = pos[idx1][1];
                float y2 = pos[idx2][1];
                float toY1 = fromTop ? Math.max(y1, targetR) : Math.min(y1, targetR);
                float toY2 = fromTop ? Math.max(y2, targetL) : Math.min(y2, targetL);
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                ModelUtils.remapUV(quad.m_111306_(), pos[1][1], pos[0][1], toY1, uv, 0, 1, idx1, true, true, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[2][1], pos[3][1], toY2, uv, 3, 2, idx2, true, true, rotated, mirrored);
                pos[idx1][1] = toY1;
                pos[idx2][1] = toY2;
                return true;
            }
            return false;
        });
    }

    public static boolean createVerticalSideQuad(BakedQuad quad, Direction dir, float length) {
        Preconditions.checkArgument((dir == quad.m_111306_().m_122427_() || dir == quad.m_111306_().m_122428_() ? 1 : 0) != 0, (Object)"Direction dir must be in the quad's plane!");
        return BakedQuadTransformer.createVerticalSideQuad(quad, !Utils.isPositive(dir), length);
    }

    public static boolean createVerticalSideQuad(BakedQuad quad, boolean positive, float length) {
        return BakedQuadTransformer.createVerticalSideQuad(quad, positive, length, length);
    }

    public static boolean createVerticalSideQuad(BakedQuad quad, Direction dir, float lengthTop, float lengthBot) {
        Preconditions.checkArgument((dir == quad.m_111306_().m_122427_() || dir == quad.m_111306_().m_122428_() ? 1 : 0) != 0, (Object)"Direction dir must be in the quad's plane!");
        return BakedQuadTransformer.createVerticalSideQuad(quad, !Utils.isPositive(dir), lengthTop, lengthBot);
    }

    public static boolean createVerticalSideQuad(BakedQuad quad, boolean positive, float lengthTop, float lengthBot) {
        return ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            int coordIdx = Utils.isX(quad.m_111306_()) ? 2 : 0;
            boolean right = Utils.isPositive(quad.m_111306_().m_122428_()) == positive;
            int vertIdxTop = right ? 3 : 0;
            int vertIdxBot = right ? 2 : 1;
            float targetTop = Mth.m_14179_((float)(1.0f - pos[vertIdxTop][1]), (float)(positive ? 1.0f - lengthTop : lengthTop), (float)(positive ? 1.0f - lengthBot : lengthBot));
            float targetBot = Mth.m_14179_((float)(1.0f - pos[vertIdxBot][1]), (float)(positive ? 1.0f - lengthTop : lengthTop), (float)(positive ? 1.0f - lengthBot : lengthBot));
            if (positive && pos[vertIdxTop][coordIdx] >= targetTop && pos[vertIdxBot][coordIdx] >= targetBot || !positive && pos[vertIdxTop][coordIdx] <= targetTop && pos[vertIdxBot][coordIdx] <= targetBot) {
                int idx1 = right ? 0 : 3;
                int idx2 = right ? 1 : 2;
                float xz1 = pos[idx1][coordIdx];
                float xz2 = pos[idx2][coordIdx];
                float toXZ1 = positive ? Math.max(xz1, targetTop) : Math.min(xz1, targetTop);
                float toXZ2 = positive ? Math.max(xz2, targetBot) : Math.min(xz2, targetBot);
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                ModelUtils.remapUV(quad.m_111306_(), pos[0][coordIdx], pos[3][coordIdx], toXZ1, uv, 0, 3, idx1, false, positive != right, rotated, mirrored);
                ModelUtils.remapUV(quad.m_111306_(), pos[1][coordIdx], pos[2][coordIdx], toXZ2, uv, 1, 2, idx2, false, positive != right, rotated, mirrored);
                pos[idx1][coordIdx] = toXZ1;
                pos[idx2][coordIdx] = toXZ2;
                return true;
            }
            return false;
        });
    }

    public static boolean createTopBottomQuad(BakedQuad quad, Direction cutDir, float length) {
        return BakedQuadTransformer.createTopBottomQuad(quad, cutDir, length, length);
    }

    public static boolean createTopBottomQuad(BakedQuad quad, Direction cutDir, float lengthR, float lengthL) {
        return ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            int coordIdx;
            int vertIdxR;
            float factorR;
            int idxR;
            boolean up;
            boolean xAxis = Utils.isX(cutDir);
            boolean positive = Utils.isPositive(cutDir);
            boolean bl = up = quad.m_111306_() == Direction.UP;
            int n = xAxis ? (positive ? 2 : 1) : (idxR = up == positive ? 1 : 0);
            int idxL = xAxis ? (positive ? 3 : 0) : (up == positive ? 2 : 3);
            Direction perpDir = cutDir.m_122428_();
            boolean perpX = Utils.isX(perpDir);
            float f = perpX ? pos[idxR][0] : (factorR = up ? 1.0f - pos[idxR][2] : pos[idxR][2]);
            float factorL = perpX ? pos[idxL][0] : (up ? 1.0f - pos[idxL][2] : pos[idxL][2]);
            float targetR = Mth.m_14179_((float)factorR, (float)(positive ? lengthR : 1.0f - lengthR), (float)(positive ? lengthL : 1.0f - lengthL));
            float targetL = Mth.m_14179_((float)factorL, (float)(positive ? lengthR : 1.0f - lengthR), (float)(positive ? lengthL : 1.0f - lengthL));
            int n2 = xAxis ? (positive ? 1 : 3) : (up ? (positive ? 0 : 2) : (vertIdxR = positive ? 1 : 3));
            int vertIdxL = xAxis ? (positive ? 0 : 2) : (up ? (positive ? 3 : 1) : (positive ? 2 : 0));
            int n3 = coordIdx = xAxis ? 0 : 2;
            if (positive && pos[vertIdxR][coordIdx] <= targetR && pos[vertIdxL][coordIdx] <= targetL || !positive && pos[vertIdxR][coordIdx] >= targetR && pos[vertIdxL][coordIdx] >= targetL) {
                float xz1 = pos[idxR][coordIdx];
                float xz2 = pos[idxL][coordIdx];
                float toXZ1 = positive ? Math.min(xz1, targetR) : Math.max(xz1, targetR);
                float toXZ2 = positive ? Math.min(xz2, targetL) : Math.max(xz2, targetL);
                boolean rotated = ModelUtils.isQuadRotated(uv);
                boolean mirrored = ModelUtils.isQuadMirrored(uv);
                if (xAxis) {
                    ModelUtils.remapUV(quad.m_111306_(), pos[1][coordIdx], pos[2][coordIdx], toXZ1, uv, 1, 2, idxR, false, false, rotated, mirrored);
                    ModelUtils.remapUV(quad.m_111306_(), pos[0][coordIdx], pos[3][coordIdx], toXZ2, uv, 0, 3, idxL, false, false, rotated, mirrored);
                } else {
                    ModelUtils.remapUV(quad.m_111306_(), pos[1][coordIdx], pos[0][coordIdx], toXZ1, uv, 0, 1, idxR, true, !up, rotated, mirrored);
                    ModelUtils.remapUV(quad.m_111306_(), pos[2][coordIdx], pos[3][coordIdx], toXZ2, uv, 3, 2, idxL, true, !up, rotated, mirrored);
                }
                pos[idxR][coordIdx] = toXZ1;
                pos[idxL][coordIdx] = toXZ2;
                return true;
            }
            return false;
        });
    }

    public static boolean createTopBottomQuad(BakedQuad quad, float minX, float minZ, float maxX, float maxZ) {
        if (minX > 0.0f && !BakedQuadTransformer.createTopBottomQuad(quad, Direction.WEST, 1.0f - minX)) {
            return false;
        }
        if (maxX < 1.0f && !BakedQuadTransformer.createTopBottomQuad(quad, Direction.EAST, maxX)) {
            return false;
        }
        if (minZ > 0.0f && !BakedQuadTransformer.createTopBottomQuad(quad, Direction.NORTH, 1.0f - minZ)) {
            return false;
        }
        return !(maxZ < 1.0f) || BakedQuadTransformer.createTopBottomQuad(quad, Direction.SOUTH, maxZ);
    }

    public static boolean createSideQuad(BakedQuad quad, float minXZ, float minY, float maxXZ, float maxY) {
        if (minXZ > 0.0f && !BakedQuadTransformer.createVerticalSideQuad(quad, true, 1.0f - minXZ)) {
            return false;
        }
        if (maxXZ < 1.0f && !BakedQuadTransformer.createVerticalSideQuad(quad, false, maxXZ)) {
            return false;
        }
        if (minY > 0.0f && !BakedQuadTransformer.createHorizontalSideQuad(quad, true, 1.0f - minY)) {
            return false;
        }
        return !(maxY < 1.0f) || BakedQuadTransformer.createHorizontalSideQuad(quad, false, maxY);
    }

    public static void setQuadPosInFacingDir(BakedQuad quad, float posTarget) {
        int idx = quad.m_111306_().m_122434_().ordinal();
        float value = Utils.isPositive(quad.m_111306_()) ? posTarget : 1.0f - posTarget;
        ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            for (int i = 0; i < 4; ++i) {
                pos[i][idx] = value;
            }
            return true;
        });
    }

    public static void setVertexPosInFacingDir(BakedQuad quad, float[] posTarget) {
        Preconditions.checkArgument((posTarget.length == 4 ? 1 : 0) != 0, (Object)"Target position array must contain 4 elements!");
        int idx = quad.m_111306_().m_122434_().ordinal();
        boolean positive = Utils.isPositive(quad.m_111306_());
        ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            for (int i = 0; i < 4; ++i) {
                pos[i][idx] = positive ? posTarget[i] : 1.0f - posTarget[i];
            }
            return true;
        });
    }

    public static void offsetQuadInDir(BakedQuad quad, Direction dir, float amount) {
        int idx = dir.m_122434_().ordinal();
        float value = Utils.isPositive(dir) ? amount : -1.0f * amount;
        ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            for (int i = 0; i < 4; ++i) {
                float[] fArray = pos[i];
                int n = idx;
                fArray[n] = fArray[n] + value;
            }
            return true;
        });
    }

    public static void rotateQuadAroundAxisCentered(BakedQuad quad, Direction.Axis axis, float angle, boolean rescale) {
        BakedQuadTransformer.rotateQuadAroundAxis(quad, axis, HALF, angle, rescale);
    }

    public static void rotateQuadAroundAxisCentered(BakedQuad quad, Direction.Axis axis, float angle, boolean rescale, Vector3f scaleMult) {
        BakedQuadTransformer.rotateQuadAroundAxis(quad, axis, HALF, angle, rescale, scaleMult);
    }

    public static void rotateQuadAroundAxis(BakedQuad quad, Direction.Axis axis, Vector3f origin, float angle, boolean rescale) {
        BakedQuadTransformer.rotateQuadAroundAxis(quad, axis, origin, angle, rescale, ONE);
    }

    public static void rotateQuadAroundAxis(BakedQuad quad, Direction.Axis axis, Vector3f origin, float angle, boolean rescale, Vector3f scaleMult) {
        ModelUtils.modifyQuad(quad, (pos, uv, normal) -> {
            Vector3f axisVec;
            Vector3f scaleVec = switch (axis) {
                case Direction.Axis.X -> {
                    axisVec = new Vector3f(1.0f, 0.0f, 0.0f);
                    yield new Vector3f(0.0f, 1.0f, 1.0f);
                }
                case Direction.Axis.Y -> {
                    axisVec = new Vector3f(0.0f, 1.0f, 0.0f);
                    yield new Vector3f(1.0f, 0.0f, 1.0f);
                }
                case Direction.Axis.Z -> {
                    axisVec = new Vector3f(0.0f, 0.0f, 1.0f);
                    yield new Vector3f(1.0f, 1.0f, 0.0f);
                }
                default -> throw new IllegalArgumentException("Invalid axis!");
            };
            Matrix4f transform = new Matrix4f(new Quaternion(axisVec, angle, true));
            if (rescale) {
                float scaleAngle;
                float f = scaleAngle = Mth.m_14154_((float)angle) > 45.0f ? 90.0f - Mth.m_14154_((float)angle) : Mth.m_14154_((float)angle);
                if (scaleAngle == 22.5f) {
                    scaleVec.m_122261_(SCALE_ROTATION_22_5);
                } else if (scaleAngle == 45.0f) {
                    scaleVec.m_122261_(SCALE_ROTATION_45);
                } else {
                    float scaleFactor = 1.0f / (float)Math.cos(Math.PI / (180.0 / (double)scaleAngle)) - 1.0f;
                    scaleVec.m_122261_(scaleFactor);
                }
                scaleMult.m_122258_(Math::abs);
                scaleVec.m_122263_(scaleMult.m_122239_(), scaleMult.m_122260_(), scaleMult.m_122269_());
                scaleVec.m_122272_(1.0f, 1.0f, 1.0f);
            }
            for (int i = 0; i < 4; ++i) {
                Vector4f vector4f = new Vector4f(pos[i][0] - origin.m_122239_(), pos[i][1] - origin.m_122260_(), pos[i][2] - origin.m_122269_(), 1.0f);
                if (rescale) {
                    vector4f.m_123611_(scaleVec);
                }
                vector4f.m_123607_(transform);
                pos[i][0] = vector4f.m_123601_() + origin.m_122239_();
                pos[i][1] = vector4f.m_123615_() + origin.m_122260_();
                pos[i][2] = vector4f.m_123616_() + origin.m_122269_();
            }
            return true;
        });
    }

    private BakedQuadTransformer() {
    }
}

