/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.helper;

import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;

public final class HudHelper {
    public static HudPos getHudPos() {
        Window window = Minecraft.m_91087_().m_91268_();
        int xOffset = (Integer)ModConfigs.HUD_OFFSET_X.get();
        int yOffset = (Integer)ModConfigs.HUD_OFFSET_Y.get();
        return switch ((Integer)ModConfigs.HUD_POSITION.get()) {
            case 0 -> new HudPos(10 + xOffset, 30 + yOffset, 0);
            case 1 -> new HudPos(10 + xOffset, window.m_85446_() / 2 + yOffset, 0);
            case 2 -> new HudPos(10 + xOffset, window.m_85446_() - 30 + yOffset, 0);
            case 3 -> new HudPos(window.m_85445_() - 8 - xOffset, 30 + yOffset, 1);
            case 4 -> new HudPos(window.m_85445_() - 8 - xOffset, window.m_85446_() / 2 + yOffset, 1);
            case 5 -> new HudPos(window.m_85445_() - 8 - xOffset, window.m_85446_() - 30 + yOffset, 1);
            default -> null;
        };
    }

    public static int getEnergyBarScaled(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (jetpack.creative) {
            return 156;
        }
        IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
        int i = energy.getEnergyStored();
        int j = energy.getMaxEnergyStored();
        return (int)(j != 0 && i != 0 ? (long)i * 156L / (long)j : 0L);
    }

    public static String getFuelString(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (jetpack.creative) {
            return ModTooltips.INFINITE.buildString() + "\u00a77 FE";
        }
        int number = JetpackUtils.getEnergyStorage(stack).getEnergyStored();
        if (number >= 1000000000) {
            int big;
            int small = (number - (big = number / 1000000000) * 1000000000) / 100000000;
            return big + (String)(small != 0 ? "." + small : "") + "\u00a77G FE";
        }
        if (number >= 1000000) {
            int big;
            int small = (number - (big = number / 1000000) * 1000000) / 100000;
            return big + (String)(small != 0 ? "." + small : "") + "\u00a77M FE";
        }
        if (number >= 1000) {
            return number / 1000 + "\u00a77k FE";
        }
        return number + "\u00a77 FE";
    }

    public static String getStatusString(boolean on) {
        return on ? "\u00a7a" + ModTooltips.ON.buildString() : "\u00a7c" + ModTooltips.OFF.buildString();
    }

    public static class HudPos {
        public int x;
        public int y;
        public int side;

        public HudPos(int x, int y, int side) {
            this.x = x;
            this.y = y;
            this.side = side;
        }
    }
}

