/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.entity;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.entity.BOPEntities;
import biomesoplenty.api.item.BOPItems;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BoatBOP
extends Boat {
    public BoatBOP(EntityType<? extends BoatBOP> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public BoatBOP(Level level, double x, double y, double z) {
        this((EntityType<? extends BoatBOP>)((EntityType)BOPEntities.BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128359_("model", this.getModel().getName());
    }

    protected void m_7378_(CompoundTag nbt) {
        if (nbt.m_128425_("model", 8)) {
            this.f_19804_.m_135381_(f_38285_, (Object)ModelType.byName(nbt.m_128461_("model")).ordinal());
        }
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getModel().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.f_19853_.m_6425_(this.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ -= (float)y;
            }
        }
    }

    public Item m_38369_() {
        switch (ModelType.byId((Integer)this.f_19804_.m_135370_(f_38285_))) {
            case FIR: {
                return (Item)BOPItems.FIR_BOAT.get();
            }
            case REDWOOD: {
                return (Item)BOPItems.REDWOOD_BOAT.get();
            }
            case CHERRY: {
                return (Item)BOPItems.CHERRY_BOAT.get();
            }
            case MAHOGANY: {
                return (Item)BOPItems.MAHOGANY_BOAT.get();
            }
            case JACARANDA: {
                return (Item)BOPItems.JACARANDA_BOAT.get();
            }
            case PALM: {
                return (Item)BOPItems.PALM_BOAT.get();
            }
            case WILLOW: {
                return (Item)BOPItems.WILLOW_BOAT.get();
            }
            case DEAD: {
                return (Item)BOPItems.DEAD_BOAT.get();
            }
            case MAGIC: {
                return (Item)BOPItems.MAGIC_BOAT.get();
            }
            case UMBRAN: {
                return (Item)BOPItems.UMBRAN_BOAT.get();
            }
            case HELLBARK: {
                return (Item)BOPItems.HELLBARK_BOAT.get();
            }
        }
        return Items.f_42453_;
    }

    public void setModel(ModelType type) {
        this.f_19804_.m_135381_(f_38285_, (Object)type.ordinal());
    }

    public ModelType getModel() {
        return ModelType.byId((Integer)this.f_19804_.m_135370_(f_38285_));
    }

    @Deprecated
    public void m_38332_(Boat.Type vanillaType) {
    }

    @Deprecated
    public Boat.Type m_38387_() {
        return Boat.Type.OAK;
    }

    public static enum ModelType {
        FIR("fir", (Block)BOPBlocks.FIR_PLANKS.get()),
        REDWOOD("redwood", (Block)BOPBlocks.REDWOOD_PLANKS.get()),
        CHERRY("cherry", (Block)BOPBlocks.CHERRY_PLANKS.get()),
        MAHOGANY("mahogany", (Block)BOPBlocks.MAHOGANY_PLANKS.get()),
        JACARANDA("jacaranda", (Block)BOPBlocks.JACARANDA_PLANKS.get()),
        PALM("palm", (Block)BOPBlocks.PALM_PLANKS.get()),
        WILLOW("willow", (Block)BOPBlocks.WILLOW_PLANKS.get()),
        DEAD("dead", (Block)BOPBlocks.DEAD_PLANKS.get()),
        MAGIC("magic", (Block)BOPBlocks.MAGIC_PLANKS.get()),
        UMBRAN("umbran", (Block)BOPBlocks.UMBRAN_PLANKS.get()),
        HELLBARK("hellbark", (Block)BOPBlocks.HELLBARK_PLANKS.get());

        private final String name;
        private final Block planks;

        private ModelType(String name, Block planks) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static ModelType byId(int id) {
            ModelType[] type = ModelType.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }

        public static ModelType byName(String aName) {
            ModelType[] type = ModelType.values();
            return Arrays.stream(type).filter(t -> t.getName().equals(aName)).findFirst().orElse(type[0]);
        }
    }
}

