/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.forge.DeferredRegisters;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ForgeBalmEntities
implements BalmEntities {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public <T extends Entity> DeferredObject<EntityType<T>> registerEntity(ResourceLocation identifier, EntityType.Builder<T> typeBuilder) {
        DeferredRegister register = DeferredRegisters.get(ForgeRegistries.ENTITY_TYPES, identifier.m_135827_());
        RegistryObject registryObject = register.register(identifier.m_135815_(), () -> typeBuilder.m_20712_(identifier.toString()));
        return new DeferredObject<EntityType<T>>(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    @Override
    public <T extends LivingEntity> DeferredObject<EntityType<T>> registerEntity(ResourceLocation identifier, EntityType.Builder<T> typeBuilder, Supplier<AttributeSupplier.Builder> attributeBuilder) {
        DeferredRegister register = DeferredRegisters.get(ForgeRegistries.ENTITY_TYPES, identifier.m_135827_());
        Registrations registrations = this.getActiveRegistrations();
        RegistryObject registryObject = register.register(identifier.m_135815_(), () -> {
            EntityType entityType = typeBuilder.m_20712_(identifier.toString());
            registrations.attributeSuppliers.put(entityType, ((AttributeSupplier.Builder)attributeBuilder.get()).m_22265_());
            return entityType;
        });
        return new DeferredObject<EntityType<T>>(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.getActiveRegistrations());
    }

    private Registrations getActiveRegistrations() {
        return this.registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    private static class Registrations {
        public final Map<EntityType<?>, AttributeSupplier> attributeSuppliers = new HashMap();

        private Registrations() {
        }

        @SubscribeEvent
        public void registerAttributes(EntityAttributeCreationEvent event) {
            for (Map.Entry<EntityType<?>, AttributeSupplier> entry : this.attributeSuppliers.entrySet()) {
                event.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

