/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.api.straw.StrawHandler;
import com.buuz135.industrial.registry.IFRegistries;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class StrawUtils {
    @Nonnull
    public static Optional<StrawHandler> getStrawHandler(@Nonnull Fluid stack) {
        @NotNull ArrayList<StrawHandler> current = new ArrayList<StrawHandler>(IFRegistries.STRAW_HANDLER_REGISTRY.get().getValues());
        current.sort(Comparator.comparingInt(StrawHandler::getPriority));
        for (StrawHandler handler : current) {
            if (!handler.validFluid(stack)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }
}

