/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.client.model.ConveyorModelData;
import com.buuz135.industrial.utils.MovementUtils;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ConveyorTile
extends ActiveTile<ConveyorTile>
implements IBlockContainer<ConveyorUpgradeFactory> {
    private Direction facing;
    private ConveyorBlock.EnumType type;
    private int color;
    private Map<Direction, ConveyorUpgrade> upgradeMap = new HashMap<Direction, ConveyorUpgrade>();
    private List<Integer> filter;
    private boolean sticky;
    private FluidTank tank;
    private boolean needsFluidSync;

    public ConveyorTile(BlockPos blockPos, BlockState blockState) {
        super((BasicTileBlock)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get(), (BlockEntityType)((RegistryObject)ModuleTransportStorage.CONVEYOR.getRight()).get(), blockPos, blockState);
        this.facing = Direction.NORTH;
        this.type = ConveyorBlock.EnumType.FLAT;
        this.color = DyeColor.WHITE.m_41069_().f_76396_;
        this.filter = new ArrayList<Integer>();
        this.sticky = false;
        this.tank = new FluidTank(250);
    }

    @Override
    public Level getBlockWorld() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.m_58899_();
    }

    @Override
    public void requestSync() {
        this.markForUpdate();
    }

    @Override
    public void requestFluidSync() {
        this.needsFluidSync = true;
    }

    @Override
    public boolean hasUpgrade(Direction facing) {
        return this.upgradeMap.containsKey(facing);
    }

    public int getPower() {
        int highestPower = 0;
        for (ConveyorUpgrade upgrade : this.upgradeMap.values()) {
            int power;
            if (upgrade == null || (power = upgrade.getRedstoneOutput()) <= highestPower) continue;
            highestPower = power;
        }
        return highestPower;
    }

    @Override
    public void addUpgrade(Direction facing, ConveyorUpgradeFactory upgrade) {
        if (!this.hasUpgrade(facing)) {
            this.upgradeMap.put(facing, upgrade.create(this, facing));
            this.requestSync();
            if (this.f_58857_.f_46443_) {
                this.m_58904_().getModelDataManager().requestRefresh((BlockEntity)this);
            }
        }
    }

    @Override
    public void removeUpgrade(Direction facing, boolean drop) {
        if (this.hasUpgrade(facing)) {
            if (!this.f_58857_.f_46443_ && drop) {
                ConveyorUpgrade upgrade = this.upgradeMap.get(facing);
                for (ItemStack stack : upgrade.getDrops()) {
                    ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack);
                    item.m_32045_(stack);
                    this.f_58857_.m_7967_((Entity)item);
                }
            }
            this.upgradeMap.get(facing).onUpgradeRemoved();
            this.upgradeMap.remove(facing);
            this.requestSync();
            if (this.f_58857_.f_46443_) {
                this.m_58904_().getModelDataManager().requestRefresh((BlockEntity)this);
            }
        }
    }

    @Override
    public List<Integer> getEntityFilter() {
        return this.filter;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
        this.markForUpdate();
    }

    public ConveyorBlock.EnumType getConveyorType() {
        return this.type;
    }

    public void setType(ConveyorBlock.EnumType type) {
        this.type = type;
        this.markForUpdate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.markForUpdate();
    }

    public void setColor(DyeColor color) {
        this.color = color.m_41069_().f_76396_;
        this.markForUpdate();
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
        this.markForUpdate();
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("Facing", this.facing.m_7912_());
        compound.m_128359_("Type", this.type.getName());
        compound.m_128405_("Color", this.color);
        compound.m_128379_("Sticky", this.sticky);
        CompoundTag upgrades = new CompoundTag();
        for (Direction facing : Direction.values()) {
            if (!this.hasUpgrade(facing)) continue;
            CompoundTag upgradeTag = new CompoundTag();
            ConveyorUpgrade upgrade = this.upgradeMap.get(facing);
            upgradeTag.m_128359_("factory", ForgeRegistries.ITEMS.getKey((Object)upgrade.getFactory().getUpgradeItem()).toString());
            CompoundTag customNBT = upgrade.serializeNBT();
            if (customNBT != null) {
                upgradeTag.m_128365_("customNBT", (Tag)customNBT);
            }
            upgrades.m_128365_(facing.m_7912_(), (Tag)upgradeTag);
        }
        compound.m_128365_("Upgrades", (Tag)upgrades);
        compound.m_128365_("Tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.facing = Direction.m_122402_((String)compound.m_128461_("Facing"));
        this.type = ConveyorBlock.EnumType.getFromName(compound.m_128461_("Type"));
        this.color = compound.m_128451_("Color");
        this.sticky = compound.m_128471_("Sticky");
        if (compound.m_128441_("Upgrades")) {
            CompoundTag upgradesTag = compound.m_128469_("Upgrades");
            for (Direction facing : Direction.values()) {
                if (!upgradesTag.m_128441_(facing.m_7912_())) continue;
                CompoundTag upgradeTag = upgradesTag.m_128469_(facing.m_7912_());
                ConveyorUpgradeFactory factory = null;
                for (ConveyorUpgradeFactory conveyorUpgradeFactory : ConveyorUpgradeFactory.FACTORIES) {
                    if (!ForgeRegistries.ITEMS.getKey((Object)conveyorUpgradeFactory.getUpgradeItem()).equals((Object)new ResourceLocation(upgradeTag.m_128461_("factory")))) continue;
                    factory = conveyorUpgradeFactory;
                    break;
                }
                if (factory == null) continue;
                ConveyorUpgrade upgrade = this.upgradeMap.getOrDefault(facing, factory.create(this, facing));
                if (upgradeTag.m_128441_("customNBT")) {
                    upgrade.deserializeNBT(upgradeTag.m_128469_("customNBT"));
                }
                this.upgradeMap.put(facing, upgrade);
            }
        }
        if (compound.m_128441_("Tank")) {
            this.tank = this.tank.readFromNBT(compound.m_128469_("Tank"));
        }
    }

    public void markForUpdate() {
        super.markForUpdate();
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)((BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)ConveyorBlock.FACING, (Comparable)this.facing)).m_61124_(ConveyorBlock.TYPE, (Comparable)((Object)this.type)));
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        this.f_58857_.m_7702_(this.f_58858_).m_142466_(compoundTag);
    }

    public List<AABB> getCollisionBoxes() {
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        Direction facing = this.facing;
        if (this.type.isDown()) {
            facing = facing.m_122424_();
        }
        for (double height = 1.0; height > 0.0; height -= 0.1) {
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                boxes.add(new AABB(0.0, 0.0, facing == Direction.NORTH ? 0.0 : 1.0 - height, 1.0, 1.0 - height, facing == Direction.NORTH ? height : 1.0));
            }
            if (facing != Direction.WEST && facing != Direction.EAST) continue;
            boxes.add(new AABB(facing == Direction.WEST ? 0.0 : 1.0 - height, 0.0, 0.0, facing == Direction.WEST ? height : 1.0, 1.0 - height, 1.0));
        }
        return boxes;
    }

    public void handleEntityMovement(Entity entity) {
        for (ConveyorUpgrade upgrade : this.upgradeMap.values()) {
            if (upgrade == null) continue;
            upgrade.handleEntity(entity);
        }
        if (entity.m_6084_()) {
            if (!this.getEntityFilter().contains(entity.m_19879_())) {
                MovementUtils.handleConveyorMovement(entity, this.facing, this.f_58858_, this.type);
            }
            if (entity instanceof ItemEntity && this.sticky) {
                ((ItemEntity)entity).m_32010_(5);
            }
        }
    }

    public Map<Direction, ConveyorUpgrade> getUpgradeMap() {
        return this.upgradeMap;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, ConveyorTile blockEntity) {
        BlockState state1;
        if (!level.f_46443_ && this.tank.getFluidAmount() > 0 && level.m_46467_() % 3L == 0L && level.m_8055_(this.f_58858_.m_121945_(this.facing)).m_60734_() instanceof ConveyorBlock && level.m_7702_(this.f_58858_.m_121945_(this.facing)) instanceof ConveyorTile && !((ConveyorBlock.EnumType)((Object)(state1 = level.m_8055_(this.f_58858_.m_121945_(this.facing))).m_61143_(ConveyorBlock.TYPE))).isVertical()) {
            int amount = Math.max(this.tank.getFluidAmount() - 1, 1);
            ConveyorTile conveyorTile = (ConveyorTile)level.m_7702_(this.f_58858_.m_121945_(this.facing));
            FluidStack drained = this.tank.drain(conveyorTile.getTank().fill(this.tank.drain(amount, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
            if (!drained.isEmpty() && drained.getAmount() > 0) {
                this.requestFluidSync();
                conveyorTile.requestFluidSync();
            }
        }
        if (!level.f_46443_ && level.m_46467_() % 6L == 0L && this.needsFluidSync) {
            this.markForUpdate();
            this.needsFluidSync = false;
        }
        if (this.type.isVertical() && !this.upgradeMap.isEmpty()) {
            new ArrayList<Direction>(this.upgradeMap.keySet()).forEach(facing1 -> this.removeUpgrade((Direction)facing1, true));
        }
        this.upgradeMap.values().forEach(ConveyorUpgrade::update);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, ConveyorTile blockEntity) {
    }

    @Nonnull
    public ConveyorTile getSelf() {
        return this;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new ContainerConveyor(menu, this, ((ConveyorBlock)((Object)((RegistryObject)ModuleTransportStorage.CONVEYOR.getLeft()).get())).getFacingUpgradeHit(this.f_58857_.m_8055_(this.f_58858_), this.f_58857_, this.f_58858_, entityPlayer), inventoryPlayer);
    }

    public void openGui(Player player, Direction facing) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, packetBuffer -> {
                packetBuffer.m_130064_(this.f_58858_);
                packetBuffer.m_130068_((Enum)facing);
            });
        }
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ConveyorModelData.UPGRADE_PROPERTY, (Object)new ConveyorModelData(new HashMap<Direction, ConveyorUpgrade>(this.upgradeMap))).build();
    }
}

