/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui.components;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.gui.components.DelayedTooltip;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiSlider
extends AbstractSliderButton
implements DelayedTooltip {
    protected String prefix;
    protected String suffix;
    protected double minVal;
    protected double maxVal;
    protected boolean showDec;
    protected boolean showText;
    protected Map<Double, String> additionalText = new HashMap<Double, String>();
    protected Map<Double, String> substituteText = new HashMap<Double, String>();
    protected ISlider applyValueHandler;
    protected ISlider releaseHandler;
    protected List<FormattedCharSequence> tooltip;
    private long hoverStartTime;
    private int resolution = 1;

    public GuiSlider(int xIn, int yIn, int widthIn, int heightIn, String prefix, String suffix, double minVal, double maxVal, double curVal, boolean showDec, boolean showText, ISlider applyValueHandler, ISlider releaseHandler) {
        super(xIn, yIn, widthIn, heightIn, Component.m_130674_((String)""), (curVal - minVal) / (maxVal - minVal));
        this.prefix = prefix;
        this.suffix = suffix;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.showDec = showDec;
        this.showText = showText;
        this.applyValueHandler = applyValueHandler;
        this.releaseHandler = releaseHandler;
        this.m_5695_();
    }

    public GuiSlider addSubstituteText(double val, String text) {
        this.substituteText.put(val, text);
        this.m_5695_();
        return this;
    }

    public GuiSlider addAdditionalText(double val, String text) {
        this.additionalText.put(val, text);
        this.m_5695_();
        return this;
    }

    protected void m_5695_() {
        String message;
        double dispVal;
        if (this.showDec) {
            dispVal = (double)((int)(this.getValue() * 10.0)) / 10.0;
            message = this.prefix + dispVal + this.suffix;
        } else {
            dispVal = this.getValueInt();
            message = this.prefix + (int)dispVal + this.suffix;
        }
        if (this.showText) {
            double keyVal;
            for (Map.Entry<Double, String> entry : this.substituteText.entrySet()) {
                keyVal = entry.getKey();
                if (!this.showDec) {
                    keyVal = Math.round(keyVal);
                }
                if (dispVal != keyVal) continue;
                message = this.prefix + entry.getValue();
                break;
            }
            for (Map.Entry<Double, String> entry : this.additionalText.entrySet()) {
                keyVal = entry.getKey();
                if (!this.showDec) {
                    keyVal = Math.round(keyVal);
                }
                if (dispVal != entry.getKey()) continue;
                message = message + " (" + entry.getValue() + ")";
                break;
            }
            this.m_93666_(Component.m_130674_((String)message));
        }
    }

    public void m_7691_(double posX, double posY) {
        super.m_7691_(posX, posY);
        if (this.releaseHandler != null) {
            this.releaseHandler.action(this);
        }
    }

    protected void m_5697_() {
        if (this.applyValueHandler != null) {
            this.applyValueHandler.action(this);
            Config.CURRENT.correctProfile();
        }
    }

    public int getValueInt() {
        int val = (int)Math.round(this.f_93577_ * (this.maxVal - this.minVal) + this.minVal);
        return Math.round(val / this.resolution) * this.resolution;
    }

    public double getValue() {
        return this.f_93577_ * (this.maxVal - this.minVal) + this.minVal;
    }

    public GuiSlider setResolution(int resolution) {
        this.resolution = resolution;
        return this;
    }

    public GuiSlider setTooltip(Component tooltip) {
        this.tooltip = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)tooltip, 200);
        return this;
    }

    public List<FormattedCharSequence> m_141932_() {
        return this.tooltip;
    }

    @Override
    public void setHoverTime() {
        this.hoverStartTime = System.currentTimeMillis();
    }

    @Override
    public long getHoverTime() {
        return this.hoverStartTime;
    }

    @Override
    public void clearHoverTime() {
        this.hoverStartTime = 0L;
    }

    public static interface ISlider {
        public void action(GuiSlider var1);
    }
}

