/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;

public class SuperGravityProcessor
extends StructureProcessor {
    public static final Codec<SuperGravityProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Heightmap.Types.f_64274_.fieldOf("heightmap").orElse((Object)Heightmap.Types.WORLD_SURFACE_WG).forGetter(superGravityProcessor -> superGravityProcessor.heightmap), (App)Codec.INT.fieldOf("offset").orElse((Object)0).forGetter(superGravityProcessor -> superGravityProcessor.offset), (App)Registry.f_122824_.m_194605_().listOf().fieldOf("ignore_block").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(superGravityProcessor -> superGravityProcessor.blocksToIgnore), (App)Codec.BOOL.fieldOf("require_water_surface").orElse((Object)false).forGetter(superGravityProcessor -> superGravityProcessor.requireWaterSurface)).apply((Applicative)instance, SuperGravityProcessor::new));
    private final Heightmap.Types heightmap;
    private final int offset;
    private final HashSet<Block> blocksToIgnore;
    private final boolean requireWaterSurface;

    public SuperGravityProcessor(Heightmap.Types types, int offset, HashSet<Block> blocksToIgnore, boolean requireWaterSurface) {
        this.heightmap = types;
        this.offset = offset;
        this.blocksToIgnore = blocksToIgnore;
        this.requireWaterSurface = requireWaterSurface;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings placeSettings) {
        Heightmap.Types heightmap$types = levelReader instanceof ServerLevel ? (this.heightmap == Heightmap.Types.WORLD_SURFACE_WG ? Heightmap.Types.WORLD_SURFACE : (this.heightmap == Heightmap.Types.OCEAN_FLOOR_WG ? Heightmap.Types.OCEAN_FLOOR : this.heightmap)) : this.heightmap;
        int heightmapY = levelReader.m_6924_(heightmap$types, structureBlockInfoWorld.f_74675_.m_123341_(), structureBlockInfoWorld.f_74675_.m_123343_());
        int localY = structureBlockInfoLocal.f_74675_.m_123342_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122178_(structureBlockInfoWorld.f_74675_.m_123341_(), heightmapY, structureBlockInfoWorld.f_74675_.m_123343_());
        BlockState aboveState = levelReader.m_8055_((BlockPos)mutable);
        mutable.m_122173_(Direction.DOWN);
        BlockState currentState = levelReader.m_8055_((BlockPos)mutable);
        while (this.blocksToIgnore.contains(currentState.m_60734_()) || this.requireWaterSurface && currentState.m_60767_() == Material.f_76305_) {
            aboveState = currentState;
            mutable.m_122173_(Direction.DOWN);
            currentState = levelReader.m_8055_((BlockPos)mutable);
        }
        if (this.requireWaterSurface ? aboveState.m_60767_() == Material.f_76305_ : aboveState.m_60795_()) {
            return new StructureTemplate.StructureBlockInfo(new BlockPos(structureBlockInfoWorld.f_74675_.m_123341_(), mutable.m_123342_() + localY + this.offset, structureBlockInfoWorld.f_74675_.m_123343_()), structureBlockInfoWorld.f_74676_, structureBlockInfoWorld.f_74677_);
        }
        return null;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)RSProcessors.SUPER_GRAVITY_PROCESSOR.get();
    }
}

