/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.structures.TemplateAccessor;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.configs.NbtDungeonConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class NbtDungeon
extends Feature<NbtDungeonConfig> {
    public NbtDungeon(Codec<NbtDungeonConfig> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<NbtDungeonConfig> context) {
        BlockPos position = context.m_159777_().m_6630_(-1);
        ResourceLocation nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(((NbtDungeonConfig)context.m_159778_()).nbtResourcelocationsAndWeights, context.m_225041_());
        StructureTemplateManager structureTemplateManager = context.m_159774_().m_6018_().m_215082_();
        Optional template = structureTemplateManager.m_230407_(nbtRL);
        if (template.isEmpty()) {
            RepurposedStructures.LOGGER.error("Identifier to the specified nbt file was not found! : {}", (Object)nbtRL);
            return false;
        }
        Rotation rotation = Rotation.m_221990_((RandomSource)context.m_225041_());
        BlockPos size = new BlockPos(((StructureTemplate)template.get()).m_163801_());
        BlockPos halfLengths = new BlockPos(size.m_123341_() / 2, size.m_123342_() / 2, size.m_123343_() / 2);
        BlockPos fullLengths = new BlockPos(Math.abs(size.m_7954_(rotation).m_123341_()), Math.abs(size.m_7954_(rotation).m_123342_()), Math.abs(size.m_7954_(rotation).m_123343_()));
        BlockPos halfLengthsRotated = new BlockPos(fullLengths.m_123341_() / 2, fullLengths.m_123342_() / 2, fullLengths.m_123343_() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position);
        ChunkAccess cachedChunk = context.m_159774_().m_46865_((BlockPos)mutable);
        int xMin = -halfLengthsRotated.m_123341_();
        int xMax = halfLengthsRotated.m_123341_();
        int zMin = -halfLengthsRotated.m_123343_();
        int zMax = halfLengthsRotated.m_123343_();
        int wallOpenings = 0;
        int ceilingOpenings = 0;
        int ceiling = size.m_123342_();
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = 0; y <= ceiling; ++y) {
                    mutable.m_122190_((Vec3i)position).m_122184_(x, y, z);
                    if (mutable.m_123341_() >> 4 != cachedChunk.m_7697_().f_45578_ || mutable.m_123343_() >> 4 != cachedChunk.m_7697_().f_45579_) {
                        cachedChunk = context.m_159774_().m_46865_((BlockPos)mutable);
                    }
                    BlockState state = cachedChunk.m_8055_((BlockPos)mutable);
                    if (((NbtDungeonConfig)context.m_159778_()).airRequirementIsNowWater ? state.m_60795_() || state.m_60819_().m_205070_(FluidTags.f_13132_) : !state.m_60819_().m_76178_()) {
                        return false;
                    }
                    if (!GeneralUtils.isFullCube((BlockGetter)context.m_159774_(), (BlockPos)mutable, state)) {
                        if (y == 0 && !state.m_60767_().m_76333_()) {
                            return false;
                        }
                        if (state.m_204336_(BlockTags.f_13035_)) continue;
                        if (y == ceiling) {
                            ++ceilingOpenings;
                        }
                    }
                    if ((x == xMin || x == xMax || z == zMin || z == zMax) && y == 1 && this.isValidNonSolidBlock((NbtDungeonConfig)context.m_159778_(), state)) {
                        BlockState aboveState = cachedChunk.m_8055_((BlockPos)mutable);
                        if (((NbtDungeonConfig)context.m_159778_()).airRequirementIsNowWater ? !aboveState.m_60819_().m_76178_() : aboveState.m_60795_()) {
                            ++wallOpenings;
                        }
                    }
                    if (wallOpenings <= ((NbtDungeonConfig)context.m_159778_()).maxAirSpace && ceilingOpenings <= ((NbtDungeonConfig)context.m_159778_()).maxAirSpace) continue;
                    return false;
                }
            }
        }
        if (wallOpenings >= ((NbtDungeonConfig)context.m_159778_()).minAirSpace) {
            position = position.m_6630_(((NbtDungeonConfig)context.m_159778_()).structureYOffset);
            StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74379_(rotation).m_74385_(halfLengths).m_74392_(false);
            Optional processor = context.m_159774_().m_6018_().m_7654_().m_206579_().m_175515_(Registry.f_122883_).m_6612_(((NbtDungeonConfig)context.m_159778_()).processor);
            processor.orElse((StructureProcessorList)ProcessorLists.f_127198_.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).m_74383_(arg_0));
            BlockPos.MutableBlockPos finalPos = mutable.m_122190_((Vec3i)position).m_122184_(-halfLengths.m_123341_(), 0, -halfLengths.m_123343_());
            ((StructureTemplate)template.get()).m_230328_((ServerLevelAccessor)context.m_159774_(), (BlockPos)finalPos, (BlockPos)finalPos, placementsettings, context.m_225041_(), 2);
            placementsettings.m_74394_();
            Optional postProcessor = context.m_159774_().m_6018_().m_7654_().m_206579_().m_175515_(Registry.f_122883_).m_6612_(((NbtDungeonConfig)context.m_159778_()).postProcessor);
            postProcessor.orElse((StructureProcessorList)ProcessorLists.f_127198_.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).m_74383_(arg_0));
            List list = placementsettings.m_74387_(((TemplateAccessor)template.get()).repurposedstructures_getPalettes(), (BlockPos)mutable).m_74652_();
            StructureTemplate.processBlockInfos((LevelAccessor)context.m_159774_(), (BlockPos)mutable, (BlockPos)mutable, (StructurePlaceSettings)placementsettings, (List)list, (StructureTemplate)((StructureTemplate)template.get()));
            this.spawnLootBlocks(context.m_159774_(), context.m_225041_(), position, (NbtDungeonConfig)context.m_159778_(), fullLengths, halfLengthsRotated, mutable);
            return true;
        }
        return false;
    }

    private boolean isValidNonSolidBlock(NbtDungeonConfig config, BlockState state) {
        if (config.airRequirementIsNowWater) {
            return !state.m_60819_().m_76178_();
        }
        return state.m_60795_();
    }

    private void SolidifyBlock(WorldGenLevel world, BlockPos pos) {
        BlockState blockBelow = world.m_8055_(pos);
        if (blockBelow.m_61138_((Property)SlabBlock.f_56353_)) {
            world.m_7731_(pos, (BlockState)blockBelow.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE), 3);
        }
    }

    private void spawnLootBlocks(WorldGenLevel world, RandomSource random, BlockPos position, NbtDungeonConfig config, BlockPos fullLengths, BlockPos halfLengths, BlockPos.MutableBlockPos mutable) {
        boolean isPlacingChestLikeBlock = config.lootBlock.m_49966_().m_60734_() instanceof ChestBlock;
        int currentChestAttempt = 0;
        while (currentChestAttempt < config.maxNumOfChests) {
            boolean addedChestThisAttempt = false;
            for (int currentChestPosAttempt = 0; currentChestPosAttempt < fullLengths.m_123341_() + fullLengths.m_123343_() + halfLengths.m_123342_(); ++currentChestPosAttempt) {
                BlockState belowState;
                if (config.chanceOfSpawningLootBlockAtSpot.isPresent() && random.m_188501_() >= config.chanceOfSpawningLootBlockAtSpot.get().floatValue()) continue;
                mutable.m_122190_((Vec3i)position).m_122184_(random.m_188503_(Math.max(fullLengths.m_123341_() - 2, 1)) - halfLengths.m_123341_() + 1, random.m_188503_(Math.max(fullLengths.m_123342_() - 1, 1)), random.m_188503_(Math.max(fullLengths.m_123343_() - 2, 1)) - halfLengths.m_123343_() + 1);
                BlockState currentBlock = world.m_8055_((BlockPos)mutable);
                if (!this.isValidNonSolidBlock(config, currentBlock) || !(belowState = world.m_8055_((BlockPos)mutable.m_122173_(Direction.DOWN))).m_60783_((BlockGetter)world, (BlockPos)mutable, Direction.UP) || belowState.m_60734_() == config.lootBlock) continue;
                mutable.m_122173_(Direction.UP);
                boolean isOnWall = false;
                for (Direction neighborDirection : Direction.Plane.HORIZONTAL) {
                    mutable.m_122173_(neighborDirection);
                    BlockState neighboringState = world.m_8055_((BlockPos)mutable);
                    mutable.m_122173_(neighborDirection.m_122424_());
                    if (isPlacingChestLikeBlock && neighboringState.m_60734_() instanceof ChestBlock) {
                        boolean chestTyping;
                        if (neighboringState.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) continue;
                        BlockState currentStateForChest = GeneralUtils.orientateChest((ServerLevelAccessor)world, (BlockPos)mutable, config.lootBlock.m_49966_());
                        Direction currentDirection = (Direction)currentStateForChest.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
                        if (neighborDirection.m_122434_() == currentDirection.m_122434_()) {
                            currentDirection = currentDirection.m_122427_();
                            BlockPos wallCheckPos = mutable.m_121945_(currentDirection);
                            BlockPos wallCheckPos2 = wallCheckPos.m_121945_(neighborDirection);
                            BlockState blockState = world.m_8055_(wallCheckPos);
                            BlockState blockState2 = world.m_8055_(wallCheckPos2);
                            if (blockState.m_60767_().m_76333_() && !(blockState.m_60734_() instanceof SpawnerBlock) || blockState2.m_60767_().m_76333_() && !(blockState2.m_60734_() instanceof SpawnerBlock)) {
                                currentDirection = currentDirection.m_122424_();
                            }
                        }
                        boolean bl = chestTyping = neighborDirection.m_122421_() == currentDirection.m_122421_();
                        if (neighborDirection.m_122434_() == Direction.Axis.Z) {
                            chestTyping = !chestTyping;
                        }
                        world.m_7731_((BlockPos)mutable, (BlockState)((BlockState)((BlockState)config.lootBlock.m_49966_().m_61124_((Property)ChestBlock.f_51480_, (Comparable)Boolean.valueOf(currentBlock.m_60819_().m_205070_(FluidTags.f_13131_)))).m_61124_((Property)ChestBlock.f_51478_, (Comparable)currentDirection)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)(chestTyping ? ChestType.RIGHT : ChestType.LEFT)), 2);
                        RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)random, (BlockPos)mutable, (ResourceLocation)config.chestResourcelocation);
                        world.m_7731_((BlockPos)mutable.m_122173_(neighborDirection), (BlockState)((BlockState)neighboringState.m_61124_((Property)ChestBlock.f_51478_, (Comparable)currentDirection)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)(chestTyping ? ChestType.LEFT : ChestType.RIGHT)), 2);
                        RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)random, (BlockPos)mutable, (ResourceLocation)config.chestResourcelocation);
                        this.SolidifyBlock(world, mutable.m_7495_());
                        isOnWall = false;
                        addedChestThisAttempt = true;
                        if (++currentChestAttempt != config.maxNumOfChests) break;
                        return;
                    }
                    if (!GeneralUtils.isFullCube((BlockGetter)world, (BlockPos)mutable, neighboringState) || neighboringState.m_60734_() instanceof SpawnerBlock) continue;
                    isOnWall = true;
                }
                if (!isOnWall) continue;
                BlockState lootBlock = config.lootBlock.m_49966_();
                if (lootBlock.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    lootBlock.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(currentBlock.m_60819_().m_205070_(FluidTags.f_13131_)));
                }
                if (lootBlock.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    lootBlock = GeneralUtils.orientateChest((ServerLevelAccessor)world, (BlockPos)mutable, lootBlock);
                }
                world.m_7731_((BlockPos)mutable, lootBlock, 2);
                ++currentChestAttempt;
                addedChestThisAttempt = true;
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)random, (BlockPos)mutable, (ResourceLocation)config.chestResourcelocation);
                mutable.m_122173_(Direction.DOWN);
                if (lootBlock.m_60734_() == Blocks.f_50456_ && world.m_7702_((BlockPos)mutable) == null) {
                    EntityType<?> entity = RepurposedStructures.mobSpawnerManager.getSpawnerMob(config.rsSpawnerResourcelocation, random);
                    if (entity == null) break;
                    world.m_7731_((BlockPos)mutable, Blocks.f_50085_.m_49966_(), 2);
                    BlockEntity blockEntity = world.m_7702_((BlockPos)mutable);
                    if (!(blockEntity instanceof SpawnerBlockEntity)) break;
                    SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                    spawnerBlockEntity.m_59801_().m_45462_(entity);
                    break;
                }
                this.SolidifyBlock(world, (BlockPos)mutable);
                break;
            }
            if (addedChestThisAttempt) continue;
            ++currentChestAttempt;
        }
    }
}

