/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.entity.Bird;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class BirdModel
extends AnimatedGeoModel<Bird> {
    public ResourceLocation getTextureResource(Bird bird) {
        if (bird.m_6095_().equals(NaturalistEntityTypes.BLUEJAY.get())) {
            return new ResourceLocation("naturalist", "textures/entity/bluejay.png");
        }
        if (bird.m_6095_().equals(NaturalistEntityTypes.CANARY.get())) {
            return new ResourceLocation("naturalist", "textures/entity/canary.png");
        }
        if (bird.m_6095_().equals(NaturalistEntityTypes.CARDINAL.get())) {
            return new ResourceLocation("naturalist", "textures/entity/cardinal.png");
        }
        return new ResourceLocation("naturalist", "textures/entity/robin.png");
    }

    public ResourceLocation getModelResource(Bird bird) {
        return new ResourceLocation("naturalist", "geo/bird.geo.json");
    }

    public ResourceLocation getAnimationResource(Bird bird) {
        return new ResourceLocation("naturalist", "animations/bird.animation.json");
    }

    public void setLivingAnimations(Bird bird, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)bird, uniqueID, customPredicate);
        if (customPredicate == null) {
            return;
        }
        List extraDataOfType = customPredicate.getExtraDataOfType(EntityModelData.class);
        IBone head = this.getAnimationProcessor().getBone("head");
        head.setRotationX(((EntityModelData)extraDataOfType.get((int)0)).headPitch * ((float)Math.PI / 180));
        head.setRotationY(((EntityModelData)extraDataOfType.get((int)0)).netHeadYaw * ((float)Math.PI / 180));
    }
}

