/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.entity.Bear;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class BearModel
extends AnimatedGeoModel<Bear> {
    public ResourceLocation getModelResource(Bear crocodile) {
        return new ResourceLocation("naturalist", "geo/bear.geo.json");
    }

    public ResourceLocation getTextureResource(Bear bear) {
        if (bear.m_21660_()) {
            return new ResourceLocation("naturalist", "textures/entity/bear/bear_angry.png");
        }
        if (bear.m_5803_()) {
            return new ResourceLocation("naturalist", "textures/entity/bear/bear_sleep.png");
        }
        if (bear.isEating()) {
            if (bear.m_21205_().m_150930_(Items.f_42780_)) {
                return new ResourceLocation("naturalist", "textures/entity/bear/bear_berries.png");
            }
            if (bear.m_21205_().m_150930_(Items.f_42784_)) {
                return new ResourceLocation("naturalist", "textures/entity/bear/bear_honey.png");
            }
        }
        return new ResourceLocation("naturalist", "textures/entity/bear/bear.png");
    }

    public ResourceLocation getAnimationResource(Bear bear) {
        return new ResourceLocation("naturalist", "animations/bear.animation.json");
    }

    public void setLivingAnimations(Bear bear, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)bear, uniqueID, customPredicate);
        if (customPredicate == null) {
            return;
        }
        List extraDataOfType = customPredicate.getExtraDataOfType(EntityModelData.class);
        IBone head = this.getAnimationProcessor().getBone("head");
        if (bear.m_6162_()) {
            head.setScaleX(1.8f);
            head.setScaleY(1.8f);
            head.setScaleZ(1.8f);
        }
        if (!(bear.m_5803_() || bear.isEating() || bear.isSitting())) {
            head.setRotationX(((EntityModelData)extraDataOfType.get((int)0)).headPitch * ((float)Math.PI / 180));
            head.setRotationY(((EntityModelData)extraDataOfType.get((int)0)).netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

