/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.api.IResourceStorage;
import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.util.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidStorageCoFH
implements IFluidHandler,
IFluidStackHolder,
IResourceStorage {
    protected static Predicate<FluidStack> DEFAULT_VALIDATOR = e -> true;
    protected final int baseCapacity;
    protected Supplier<Boolean> creative = Constants.FALSE;
    protected Supplier<Boolean> enabled = Constants.TRUE;
    protected Supplier<FluidStack> emptyFluid = Constants.EMPTY_FLUID;
    protected Predicate<FluidStack> validator;
    @Nonnull
    protected FluidStack fluid = FluidStack.EMPTY;
    protected int capacity;

    public FluidStorageCoFH(int capacity) {
        this(capacity, DEFAULT_VALIDATOR);
    }

    public FluidStorageCoFH(int capacity, Predicate<FluidStack> validator) {
        this.baseCapacity = capacity;
        this.capacity = capacity;
        this.validator = validator;
    }

    public FluidStorageCoFH applyModifiers(float storageMod) {
        this.setCapacity(Math.round((float)this.baseCapacity * storageMod));
        return this;
    }

    public FluidStorageCoFH setCapacity(int capacity) {
        this.capacity = MathHelper.clamp(capacity, 0, Integer.MAX_VALUE);
        if (!this.isEmpty()) {
            this.fluid.setAmount(MathHelper.clamp(this.getAmount(), 0, capacity));
        }
        return this;
    }

    public FluidStorageCoFH setEmptyFluid(Supplier<FluidStack> emptyFluidSupplier) {
        if (emptyFluidSupplier != null && emptyFluidSupplier.get() != null) {
            this.emptyFluid = emptyFluidSupplier;
        }
        if (this.fluid.isEmpty()) {
            this.setFluidStack(this.emptyFluid.get());
        }
        return this;
    }

    public FluidStorageCoFH setCreative(Supplier<Boolean> creative) {
        this.creative = creative;
        if (!this.fluid.isEmpty() && this.isCreative()) {
            this.fluid.setAmount(this.getCapacity());
        }
        return this;
    }

    public FluidStorageCoFH setEnabled(Supplier<Boolean> enabled) {
        if (enabled != null) {
            this.enabled = enabled;
        }
        return this;
    }

    public FluidStorageCoFH setValidator(Predicate<FluidStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isFluidValid(@Nonnull FluidStack stack) {
        return this.enabled.get() != false && this.validator.test(stack);
    }

    public void setFluidStack(FluidStack stack) {
        FluidStack fluidStack = this.fluid = stack.isEmpty() ? this.emptyFluid.get() : stack;
        if (!this.fluid.isEmpty() && this.isCreative()) {
            stack.setAmount(this.capacity);
        }
    }

    public FluidStorageCoFH read(CompoundTag nbt) {
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
        this.setFluidStack(fluid);
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        this.fluid.writeToNBT(nbt);
        nbt.m_128405_("Capacity", this.baseCapacity);
        return nbt;
    }

    @Override
    public FluidStack getFluidStack() {
        return this.fluid;
    }

    @Override
    public int getAmount() {
        return this.fluid.getAmount();
    }

    @Override
    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource) || !this.enabled.get().booleanValue()) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.setFluidStack(new FluidStack(resource, Math.min(this.capacity, resource.getAmount())));
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        return filled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.fluid.isEmpty() || !this.enabled.get().booleanValue()) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute() && !this.isCreative()) {
            this.fluid.shrink(drained);
            if (this.fluid.isEmpty()) {
                this.setFluidStack(this.emptyFluid.get());
            }
        }
        return stack;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    @Override
    public boolean clear() {
        if (this.isEmpty()) {
            return false;
        }
        this.fluid = this.emptyFluid.get();
        return true;
    }

    @Override
    public void modify(int amount) {
        if (this.isCreative()) {
            amount = Math.max(amount, 0);
        }
        this.fluid.setAmount(Math.min(this.fluid.getAmount() + amount, this.getCapacity()));
        if (this.fluid.isEmpty()) {
            this.fluid = this.emptyFluid.get();
        }
    }

    @Override
    public boolean isCreative() {
        return this.creative.get();
    }

    @Override
    public int getCapacity() {
        return this.getTankCapacity(0);
    }

    @Override
    public int getStored() {
        return this.fluid.getAmount();
    }

    @Override
    public String getUnit() {
        return "mB";
    }
}

