/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidIngredient
implements Predicate<FluidStack> {
    public static final FluidIngredient EMPTY = new FluidIngredient(Stream.empty());
    private final IFluidList[] values;
    private FluidStack[] fluidStacks;
    private int amount = 1000;

    protected FluidIngredient(Stream<? extends IFluidList> fluidLists) {
        this.values = (IFluidList[])fluidLists.toArray(IFluidList[]::new);
    }

    public FluidIngredient setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public FluidStack[] getFluids() {
        this.dissolve();
        return this.fluidStacks;
    }

    private void dissolve() {
        if (this.fluidStacks == null) {
            this.fluidStacks = (FluidStack[])Arrays.stream(this.values).flatMap(ingredientList -> ingredientList.getFluids().stream()).distinct().toArray(FluidStack[]::new);
        }
        for (FluidStack stack : this.fluidStacks) {
            if (stack.getRawFluid() == Fluids.f_76191_) continue;
            stack.setAmount(this.amount);
        }
    }

    @Override
    public boolean test(@Nullable FluidStack test) {
        if (test == null) {
            return false;
        }
        this.dissolve();
        if (this.fluidStacks.length == 0) {
            return test.isEmpty();
        }
        for (FluidStack fluidstack : this.fluidStacks) {
            if (fluidstack.getFluid() != test.getFluid()) continue;
            return true;
        }
        return false;
    }

    public final void toNetwork(FriendlyByteBuf buffer) {
        this.dissolve();
        buffer.m_130130_(this.fluidStacks.length);
        for (FluidStack matchingStack : this.fluidStacks) {
            buffer.writeFluidStack(matchingStack);
        }
    }

    public JsonElement toJson() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray jsonarray = new JsonArray();
        for (IFluidList list : this.values) {
            jsonarray.add((JsonElement)list.serialize());
        }
        return jsonarray;
    }

    public boolean isEmpty() {
        return this.values.length == 0 && (this.fluidStacks == null || this.fluidStacks.length == 0);
    }

    public static FluidIngredient fromValues(Stream<? extends IFluidList> stream) {
        FluidIngredient fluidIngredient = new FluidIngredient(stream);
        return fluidIngredient.values.length == 0 ? EMPTY : fluidIngredient;
    }

    public static FluidIngredient of(FluidStack ... stacks) {
        return FluidIngredient.of(Arrays.stream(stacks));
    }

    public static FluidIngredient of(Stream<FluidStack> stacks) {
        return FluidIngredient.fromValues(stacks.filter(stack -> !stack.isEmpty()).map(SingleFluidList::new));
    }

    public static FluidIngredient of(TagKey<Fluid> tagIn, int amount) {
        return FluidIngredient.fromValues(Stream.of(new TagList(tagIn, amount)));
    }

    public static FluidIngredient fromNetwork(FriendlyByteBuf buffer) {
        int i = buffer.m_130242_();
        return FluidIngredient.fromValues(Stream.generate(() -> new SingleFluidList(buffer.readFluidStack())).limit(i));
    }

    public static FluidIngredient fromJson(@Nullable JsonElement jsonElement) {
        if (jsonElement != null && !jsonElement.isJsonNull()) {
            if (jsonElement.isJsonObject()) {
                return FluidIngredient.fromValues(Stream.of(FluidIngredient.valueFromJson(jsonElement.getAsJsonObject())));
            }
            if (jsonElement.isJsonArray()) {
                JsonArray jsonarray = jsonElement.getAsJsonArray();
                if (jsonarray.size() == 0) {
                    throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
                }
                return FluidIngredient.fromValues(StreamSupport.stream(jsonarray.spliterator(), false).map(p_209355_0_ -> FluidIngredient.valueFromJson(GsonHelper.m_13918_((JsonElement)p_209355_0_, (String)"fluid"))));
            }
            throw new JsonSyntaxException("Expected fluid to be object or array of objects");
        }
        throw new JsonSyntaxException("Fluid cannot be null");
    }

    public static IFluidList valueFromJson(JsonObject jsonObject) {
        if (jsonObject.has("fluid") && jsonObject.has("fluid_tag")) {
            throw new JsonParseException("A fluid ingredient entry is either a fluid tag or a fluid, not both");
        }
        if (jsonObject.has("fluid")) {
            ResourceLocation resourcelocation1 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"fluid"));
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourcelocation1);
            if (fluid == null) {
                throw new JsonSyntaxException("Unknown fluid '" + resourcelocation1 + "'");
            }
            int amount = 1000;
            if (jsonObject.has("amount")) {
                amount = jsonObject.get("amount").getAsInt();
            } else if (jsonObject.has("count")) {
                amount = jsonObject.get("count").getAsInt();
            }
            return new SingleFluidList(new FluidStack(fluid, amount));
        }
        if (jsonObject.has("fluid_tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"fluid_tag"));
            TagKey key = FluidTags.create((ResourceLocation)resourcelocation);
            int amount = 1000;
            if (jsonObject.has("amount")) {
                amount = jsonObject.get("amount").getAsInt();
            } else if (jsonObject.has("count")) {
                amount = jsonObject.get("count").getAsInt();
            }
            return new TagList((TagKey<Fluid>)key, amount);
        }
        throw new JsonParseException("A fluid ingredient entry needs either a fluid_tag or a fluid");
    }

    public static interface IFluidList {
        public Collection<FluidStack> getFluids();

        public JsonObject serialize();
    }

    public static class TagList
    implements IFluidList {
        private final TagKey<Fluid> tag;
        private final int amount;

        public TagList(TagKey<Fluid> tag, int amount) {
            this.tag = tag;
            this.amount = amount;
        }

        @Override
        public Collection<FluidStack> getFluids() {
            ArrayList list = Lists.newArrayList();
            for (Holder fluid : Registry.f_122822_.m_206058_(this.tag)) {
                list.add(new FluidStack((Fluid)fluid.m_203334_(), this.amount));
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("fluid_tag", this.tag.f_203868_().toString());
            jsonobject.addProperty("amount", (Number)this.amount);
            return jsonobject;
        }
    }

    public static class SingleFluidList
    implements IFluidList {
        private final FluidStack fluid;

        public SingleFluidList(FluidStack fluid) {
            this.fluid = fluid;
        }

        @Override
        public Collection<FluidStack> getFluids() {
            return Collections.singleton(this.fluid);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid.getFluid()).toString());
            jsonobject.addProperty("amount", (Number)this.fluid.getAmount());
            return jsonobject;
        }
    }
}

