/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.item.ILeftClickHandlerItem;
import cofh.core.item.IMultiModeItem;
import com.google.common.base.Strings;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public final class ItemHelper {
    private ItemHelper() {
    }

    public static ItemStack consumeItem(ItemStack stack, int amount) {
        boolean largerStack;
        if (amount <= 0) {
            return stack;
        }
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Item item = stack.m_41720_();
        boolean bl = largerStack = stack.m_41720_().getMaxStackSize(stack) > 1;
        if (largerStack) {
            stack.m_41774_(amount);
            if (stack.m_41619_()) {
                stack = ItemStack.f_41583_;
            }
        } else if (item.hasCraftingRemainingItem(stack)) {
            ItemStack ret = item.getCraftingRemainingItem(stack);
            if (ret.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (ret.m_41763_() && ret.m_41773_() > ret.m_41776_()) {
                ret = ItemStack.f_41583_;
            }
            return ret;
        }
        return largerStack ? stack : ItemStack.f_41583_;
    }

    public static ItemStack cloneStack(Item item) {
        return ItemHelper.cloneStack(item, 1);
    }

    public static ItemStack cloneStack(Block block) {
        return ItemHelper.cloneStack(block, 1);
    }

    public static ItemStack cloneStack(Item item, int stackSize) {
        if (item == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)item, stackSize);
    }

    public static ItemStack cloneStack(Block block, int stackSize) {
        if (block == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)block, stackSize);
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.m_41619_() || stackSize <= 0) {
            return ItemStack.f_41583_;
        }
        ItemStack retStack = stack.m_41777_();
        retStack.m_41764_(stackSize);
        return retStack;
    }

    public static ItemStack cloneStack(ItemStack stack) {
        return stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_();
    }

    public static ItemStack copyTag(ItemStack container, ItemStack other) {
        if (!other.m_41619_() && other.m_41782_()) {
            container.m_41751_(other.m_41783_().m_6426_());
        }
        return container;
    }

    public static CompoundTag setItemStackTagName(CompoundTag tag, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        if (tag == null) {
            tag = new CompoundTag();
        }
        if (!tag.m_128441_("display")) {
            tag.m_128365_("display", (Tag)new CompoundTag());
        }
        tag.m_128469_("display").m_128359_("Name", name);
        return tag;
    }

    public static boolean itemsEqualWithTags(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqual(stackA, stackB) && ItemStack.m_41658_((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean itemsEqual(ItemStack stackA, ItemStack stackB) {
        return ItemStack.m_41746_((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean areItemStacksEqualIgnoreTags(ItemStack stackA, ItemStack stackB, String ... nbtTagsToIgnore) {
        if (stackA.m_41619_() && stackB.m_41619_()) {
            return true;
        }
        if (stackA.m_41619_() || stackB.m_41619_()) {
            return false;
        }
        if (stackA.m_41720_() != stackB.m_41720_()) {
            return false;
        }
        if (stackA.m_41773_() != stackB.m_41773_()) {
            return false;
        }
        if (stackA.m_41613_() != stackB.m_41613_()) {
            return false;
        }
        if (stackA.m_41783_() == null && stackB.m_41783_() == null) {
            return true;
        }
        if (stackA.m_41783_() == null || stackB.m_41783_() == null) {
            return false;
        }
        int numberOfKeys = stackA.m_41783_().m_128431_().size();
        if (numberOfKeys != stackB.m_41783_().m_128431_().size()) {
            return false;
        }
        CompoundTag tagA = stackA.m_41783_();
        CompoundTag tagB = stackB.m_41783_();
        String[] keys = new String[numberOfKeys];
        keys = tagA.m_128431_().toArray(keys);
        block0: for (int i = 0; i < numberOfKeys; ++i) {
            for (int j = 0; j < nbtTagsToIgnore.length; ++j) {
                if (nbtTagsToIgnore[j].equals(keys[i])) continue block0;
            }
            if (tagA.m_128469_(keys[i]).equals((Object)tagB.m_128469_(keys[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayerHoldingSomething(Player player) {
        return !ItemHelper.getHeldStack(player).m_41619_();
    }

    public static ItemStack getMainhandStack(Player player) {
        return player.m_21205_();
    }

    public static ItemStack getOffhandStack(Player player) {
        return player.m_21206_();
    }

    public static ItemStack getHeldStack(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            stack = player.m_21206_();
        }
        return stack;
    }

    public static ItemStack getHeldMultiModeStack(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !(stack.m_41720_() instanceof IMultiModeItem)) {
            stack = player.m_21206_();
        }
        return stack;
    }

    public static boolean isPlayerHoldingMultiModeItem(Player player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof IMultiModeItem) {
            return true;
        }
        heldItem = player.m_21206_();
        return heldItem.m_41720_() instanceof IMultiModeItem;
    }

    public static boolean incrHeldMultiModeItemState(Player player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_41720_() instanceof IMultiModeItem ? ((IMultiModeItem)mainHand.m_41720_()).incrMode(mainHand) : offHand.m_41720_() instanceof IMultiModeItem && ((IMultiModeItem)offHand.m_41720_()).incrMode(offHand);
    }

    public static boolean decrHeldMultiModeItemState(Player player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        return mainHand.m_41720_() instanceof IMultiModeItem ? ((IMultiModeItem)mainHand.m_41720_()).decrMode(mainHand) : offHand.m_41720_() instanceof IMultiModeItem && ((IMultiModeItem)offHand.m_41720_()).decrMode(offHand);
    }

    public static void onHeldMultiModeItemChange(Player player) {
        ItemStack heldItem = ItemHelper.getHeldMultiModeStack(player);
        ((IMultiModeItem)heldItem.m_41720_()).onModeChange(player, heldItem);
    }

    public static boolean isPlayerHoldingLeftClickItem(Player player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        return player.m_21205_().m_41720_() instanceof ILeftClickHandlerItem;
    }

    public static void onHeldLeftClickItem(Player player) {
        ItemStack heldItem = player.m_21205_();
        ((ILeftClickHandlerItem)heldItem.m_41720_()).onLeftClick(player, heldItem);
    }
}

