/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.capability.CapabilityArchery;
import cofh.core.capability.templates.ArcheryAmmoItemWrapper;
import cofh.core.capability.templates.ArcheryBowItemWrapper;
import cofh.core.compat.curios.CuriosProxy;
import cofh.lib.api.capability.IArcheryAmmoItem;
import cofh.lib.api.capability.IArcheryBowItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public final class ArcheryHelper {
    private static final Set<Item> VALID_BOWS = new HashSet<Item>();

    public static boolean addValidBow(Item bow) {
        return VALID_BOWS.add(bow);
    }

    private ArcheryHelper() {
    }

    public static boolean validBow(ItemStack stack) {
        return VALID_BOWS.contains(stack.m_41720_()) || stack.getCapability(CapabilityArchery.BOW_ITEM_CAPABILITY).isPresent();
    }

    public static boolean isArrow(ItemStack stack) {
        return stack.m_41720_() instanceof ArrowItem;
    }

    public static boolean isSimpleArrow(ItemStack stack) {
        return stack.m_41720_().equals(Items.f_42412_);
    }

    public static boolean fireArrow(ItemStack bow, ItemStack ammo, Player shooter, int charge, Level world) {
        boolean infinite;
        IArcheryBowItem bowCap = (IArcheryBowItem)bow.getCapability(CapabilityArchery.BOW_ITEM_CAPABILITY).orElse((Object)new ArcheryBowItemWrapper(bow));
        IArcheryAmmoItem ammoCap = (IArcheryAmmoItem)ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).orElse((Object)new ArcheryAmmoItemWrapper(ammo));
        boolean bl = infinite = shooter.m_150110_().f_35937_ || ammoCap.isInfinite(bow, shooter) || ArcheryHelper.isArrow(ammo) && ((ArrowItem)ammo.m_41720_()).isInfinite(ammo, bow, shooter) || ammo.m_41619_() && Utils.getItemEnchantmentLevel(Enchantments.f_44952_, bow) > 0;
        if (!ammo.m_41619_() || infinite) {
            float arrowVelocity;
            if (ammo.m_41619_()) {
                ammo = new ItemStack((ItemLike)Items.f_42412_);
            }
            if ((arrowVelocity = BowItem.m_40661_((int)charge)) >= 0.1f) {
                if (Utils.isServerWorld(world)) {
                    float accuracyMod = bowCap.getAccuracyModifier(shooter);
                    float damageMod = bowCap.getDamageModifier(shooter);
                    float velocityMod = bowCap.getVelocityModifier(shooter);
                    int encVolley = Utils.getItemEnchantmentLevel(Utils.getEnchantment("ensorcellation", "volley"), bow);
                    int encTrueshot = Utils.getItemEnchantmentLevel(Utils.getEnchantment("ensorcellation", "trueshot"), bow);
                    int encPunch = Utils.getItemEnchantmentLevel(Enchantments.f_44989_, bow);
                    int encPower = Utils.getItemEnchantmentLevel(Enchantments.f_44988_, bow);
                    int encFlame = Utils.getItemEnchantmentLevel(Enchantments.f_44990_, bow);
                    if (encTrueshot > 0) {
                        accuracyMod *= 1.5f / (float)(1 + encTrueshot);
                        damageMod *= 1.0f + 0.25f * (float)encTrueshot;
                        arrowVelocity = MathHelper.clamp(0.1f, arrowVelocity + 0.05f * (float)encTrueshot, 1.75f);
                    }
                    int numArrows = encVolley > 0 ? 3 : 1;
                    float volleyPitch = encVolley > 0 ? MathHelper.clamp(90.0f + shooter.m_146909_() / (float)encVolley, 0.0f, 5.0f) : 0.0f;
                    BowItem bowItem = bow.m_41720_() instanceof BowItem ? (BowItem)bow.m_41720_() : null;
                    for (int shot = 0; shot < numArrows; ++shot) {
                        AbstractArrow arrow = ArcheryHelper.createArrow(world, ammo, shooter);
                        if (bowItem != null) {
                            arrow = bowItem.customArrow(arrow);
                        }
                        arrow.m_37251_((Entity)shooter, shooter.m_146909_() - volleyPitch * (float)shot, shooter.m_146908_(), 0.0f, arrowVelocity * 3.0f * velocityMod, accuracyMod);
                        arrow.m_36781_(arrow.m_36789_() * (double)damageMod);
                        if (arrowVelocity >= 1.0f) {
                            arrow.m_36762_(true);
                        }
                        if (encTrueshot > 0) {
                            arrow.m_36767_((byte)encTrueshot);
                        }
                        if (encPower > 0 && arrow.m_36789_() > 0.0) {
                            arrow.m_36781_(arrow.m_36789_() + (double)encPower * 0.5 + 0.5);
                        }
                        if (encPunch > 0) {
                            arrow.m_36735_(encPunch);
                        }
                        if (encFlame > 0) {
                            arrow.m_20254_(100);
                        }
                        if (infinite || shot > 0) {
                            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        world.m_7967_((Entity)arrow);
                    }
                    bowCap.onArrowLoosed(shooter);
                }
                world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
                if (!infinite && !shooter.m_150110_().f_35937_) {
                    ammoCap.onArrowLoosed(shooter);
                    if (ammo.m_41619_()) {
                        shooter.m_150109_().m_36057_(ammo);
                    }
                }
                shooter.m_36246_(Stats.f_12982_.m_12902_((Object)bow.m_41720_()));
            }
            return true;
        }
        return false;
    }

    public static AbstractArrow createArrow(Level world, ItemStack ammo, Player shooter) {
        LazyOptional ammoCap = ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY);
        return ammoCap.map(cap -> cap.createArrowEntity(world, shooter)).orElse(ArcheryHelper.createDefaultArrow(world, ammo, shooter));
    }

    public static AbstractArrow createDefaultArrow(Level world, ItemStack ammo, Player shooter) {
        return ArcheryHelper.isArrow(ammo) ? ((ArrowItem)ammo.m_41720_()).m_6394_(world, ammo, (LivingEntity)shooter) : ((ArrowItem)Items.f_42412_).m_6394_(world, ammo, (LivingEntity)shooter);
    }

    public static ItemStack findAmmo(Player shooter, ItemStack weapon) {
        Predicate isAmmo;
        Predicate predicate;
        ItemStack offHand = shooter.m_21206_();
        ItemStack mainHand = shooter.m_21205_();
        Item item = weapon.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)item;
            predicate = weaponItem.m_6442_();
        } else {
            predicate = i -> false;
        }
        Predicate isHeldAmmo = predicate;
        Item item2 = weapon.m_41720_();
        if (item2 instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)item2;
            v1 = weaponItem.m_6437_();
        } else {
            v1 = isAmmo = i -> false;
        }
        if (offHand.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).map(cap -> !cap.isEmpty(shooter)).orElse(false).booleanValue() || isHeldAmmo.test(offHand)) {
            return offHand;
        }
        if (mainHand.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).map(cap -> !cap.isEmpty(shooter)).orElse(false).booleanValue() || isHeldAmmo.test(mainHand)) {
            return mainHand;
        }
        ItemStack[] retStack = new ItemStack[]{ItemStack.f_41583_};
        CuriosProxy.getAllWorn((LivingEntity)shooter).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                ItemStack slot = c.getStackInSlot(i);
                if (!slot.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).map(cap -> !cap.isEmpty(shooter)).orElse(false).booleanValue()) continue;
                retStack[0] = slot;
            }
        });
        if (!retStack[0].m_41619_()) {
            return retStack[0];
        }
        for (ItemStack slot : shooter.m_150109_().f_35974_) {
            if (!slot.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).map(cap -> !cap.isEmpty(shooter)).orElse(false).booleanValue()) continue;
            return slot;
        }
        ItemStack lpeStack = shooter.m_6298_(weapon);
        if (isAmmo.test(lpeStack)) {
            return lpeStack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack findArrows(Player shooter) {
        ItemStack offHand = shooter.m_21206_();
        ItemStack mainHand = shooter.m_21205_();
        if (ArcheryHelper.isSimpleArrow(offHand)) {
            return offHand;
        }
        if (ArcheryHelper.isSimpleArrow(mainHand)) {
            return mainHand;
        }
        for (int i = 0; i < shooter.m_150109_().m_6643_(); ++i) {
            ItemStack stack = shooter.m_150109_().m_8020_(i);
            if (!ArcheryHelper.isSimpleArrow(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static Stream<EntityHitResult> findHitEntities(Level world, Projectile projectile, Vec3 startPos, Vec3 endPos, Predicate<Entity> filter) {
        Vec3 padding = new Vec3((double)projectile.m_20205_() * 0.5, (double)projectile.m_20206_() * 0.5, (double)projectile.m_20205_() * 0.5);
        return ArcheryHelper.findHitEntities(world, (Entity)projectile, startPos, endPos, projectile.m_20191_().m_82369_(projectile.m_20184_()).m_82400_(1.5), padding, filter);
    }

    public static Stream<EntityHitResult> findHitEntities(Level world, Entity exclude, Vec3 startPos, Vec3 endPos, Vec3 padding, Predicate<Entity> filter) {
        return ArcheryHelper.findHitEntities(world, exclude, startPos, endPos, new AABB(startPos, endPos).m_82400_(1.5), padding, filter);
    }

    public static Stream<EntityHitResult> findHitEntities(Level world, Entity exclude, Vec3 startPos, Vec3 endPos, AABB searchArea, Vec3 padding, Predicate<Entity> filter) {
        return world.m_6249_(exclude, searchArea, filter).stream().map(entity -> entity.m_20191_().m_82377_(padding.m_7096_(), padding.m_7098_(), padding.m_7094_()).m_82371_(startPos, endPos).map(Vec32 -> new EntityHitResult(entity, Vec32)).orElse(null)).filter(Objects::nonNull);
    }
}

