/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.client.CoreKeys;
import cofh.core.client.particle.impl.ArcParticle;
import cofh.core.client.particle.impl.BeamParticle;
import cofh.core.client.particle.impl.BlastParticle;
import cofh.core.client.particle.impl.BlastWaveParticle;
import cofh.core.client.particle.impl.FireParticle;
import cofh.core.client.particle.impl.FrostParticle;
import cofh.core.client.particle.impl.MistParticle;
import cofh.core.client.particle.impl.PlasmaBallParticle;
import cofh.core.client.particle.impl.ShardParticle;
import cofh.core.client.particle.impl.ShockwaveParticle;
import cofh.core.client.particle.impl.SparkParticle;
import cofh.core.client.particle.impl.WindSpiralParticle;
import cofh.core.client.particle.impl.WindVortexParticle;
import cofh.core.init.CoreParticles;
import cofh.lib.api.item.IColorableItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CoreClientSetupEvents {
    private static final List<Item> COLORABLE_ITEMS = new ArrayList<Item>();

    private CoreClientSetupEvents() {
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(CoreKeys.MULTIMODE_INCREMENT);
        event.register(CoreKeys.MULTIMODE_DECREMENT);
    }

    @SubscribeEvent
    public static void colorSetupItem(RegisterColorHandlersEvent.Item event) {
        ItemColors colors = event.getItemColors();
        for (Item colorable : COLORABLE_ITEMS) {
            colors.m_92689_(((IColorableItem)colorable)::getColor, new ItemLike[]{colorable});
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterGeometryLoaders event) {
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        ParticleEngine manager = Minecraft.m_91087_().f_91061_;
        manager.m_107378_((ParticleType)CoreParticles.FROST.get(), FrostParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreParticles.PLASMA.get(), PlasmaBallParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreParticles.SPARK.get(), SparkParticle.Factory::new);
        manager.m_107378_((ParticleType)CoreParticles.FIRE.get(), FireParticle::factory);
        manager.m_107378_((ParticleType)CoreParticles.BLAST.get(), BlastParticle::factory);
        manager.m_107378_((ParticleType)CoreParticles.MIST.get(), MistParticle::factory);
        manager.m_107378_((ParticleType)CoreParticles.SHOCKWAVE.get(), ShockwaveParticle::factory);
        manager.m_107378_((ParticleType)CoreParticles.BLAST_WAVE.get(), BlastWaveParticle::factory);
        manager.m_107378_((ParticleType)CoreParticles.WIND_VORTEX.get(), WindVortexParticle::factory);
        manager.m_107378_((ParticleType)CoreParticles.WIND_SPIRAL.get(), WindSpiralParticle::factory);
        manager.m_107378_((ParticleType)CoreParticles.BEAM.get(), BeamParticle::factory);
        manager.m_107378_((ParticleType)CoreParticles.STRAIGHT_ARC.get(), ArcParticle::factory);
        manager.m_107378_((ParticleType)CoreParticles.SHARD.get(), ShardParticle::factory);
    }

    public static void addColorable(Item colorable) {
        if (colorable instanceof IColorableItem) {
            COLORABLE_ITEMS.add(colorable);
        }
    }
}

