/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.init.CoreMobEffects;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class ArmorEvents {
    private static final Object2ObjectOpenHashMap<Item, Double> FALL_RESISTANCE_MAP = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<Item, Double> HAZARD_RESISTANCE_MAP = new Object2ObjectOpenHashMap();
    private static final Set<String> HAZARD_DAMAGE_TYPES = new ObjectOpenHashSet();
    private static final Set<MobEffect> HAZARD_EFFECTS = new ObjectOpenHashSet();
    private static final Object2ObjectOpenHashMap<Item, Double> STING_RESISTANCE_MAP = new Object2ObjectOpenHashMap();
    private static final Set<String> STING_DAMAGE_TYPES = new ObjectOpenHashSet();

    private ArmorEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        double stingRes;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        double hazRes = ArmorEvents.getHazardResistance((Entity)entity);
        if (hazRes > 0.0 && (source.m_19384_() || HAZARD_DAMAGE_TYPES.contains(source.m_19385_())) && entity.m_217043_().m_188500_() < hazRes) {
            entity.m_20095_();
            ArmorEvents.attemptDamagePlayerArmor((Entity)entity, amount);
            event.setCanceled(true);
        }
        if ((stingRes = ArmorEvents.getStingResistance((Entity)entity)) > 0.0 && STING_DAMAGE_TYPES.contains(source.m_19385_()) && entity.m_217043_().m_188500_() < stingRes) {
            ArmorEvents.attemptDamagePlayerArmor((Entity)entity, amount);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingFallEvent(LivingFallEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        double fallRes = ArmorEvents.getFallResistance((Entity)entity);
        if (fallRes != 0.0) {
            event.setDistance(Math.max(0.0f, event.getDistance() - (float)fallRes));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePotionApplicableEvent(MobEffectEvent.Applicable event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        MobEffectInstance effect = event.getEffectInstance();
        double hazRes = ArmorEvents.getHazardResistance((Entity)entity);
        if (hazRes > 0.0 && HAZARD_EFFECTS.contains(effect.m_19544_()) && entity.m_217043_().m_188500_() < hazRes) {
            ArmorEvents.attemptDamagePlayerArmor((Entity)entity, (float)((1 + effect.m_19564_()) * effect.m_19557_()) / 40.0f);
            event.setResult(Event.Result.DENY);
        }
    }

    private static void attemptDamagePlayerArmor(Entity entity, float amount) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (100.0f * entity.f_19853_.f_46441_.m_188501_() < amount) {
                player.m_150109_().m_150072_(DamageSource.f_19318_, Math.min(20.0f, amount), Inventory.f_150068_);
            }
        }
    }

    private static double getFallResistance(Entity entity) {
        double ret = 0.0;
        for (ItemStack armor : entity.m_6168_()) {
            ret += ((Double)FALL_RESISTANCE_MAP.getOrDefault((Object)armor.m_41720_(), (Object)0.0)).doubleValue();
        }
        return ret;
    }

    private static double getHazardResistance(Entity entity) {
        double ret = 0.0;
        for (ItemStack armor : entity.m_6168_()) {
            ret += ((Double)HAZARD_RESISTANCE_MAP.getOrDefault((Object)armor.m_41720_(), (Object)0.0)).doubleValue();
        }
        return ret;
    }

    private static double getStingResistance(Entity entity) {
        double ret = 0.0;
        for (ItemStack armor : entity.m_6168_()) {
            ret += ((Double)STING_RESISTANCE_MAP.getOrDefault((Object)armor.m_41720_(), (Object)0.0)).doubleValue();
        }
        return ret;
    }

    public static void registerFallResistArmor(Item armor, double resistance) {
        FALL_RESISTANCE_MAP.put((Object)armor, (Object)resistance);
    }

    public static void registerHazardResistArmor(Item armor, double resistance) {
        HAZARD_RESISTANCE_MAP.put((Object)armor, (Object)resistance);
    }

    public static void registerStingResistArmor(Item armor, double resistance) {
        STING_RESISTANCE_MAP.put((Object)armor, (Object)resistance);
    }

    public static void setup() {
        STING_DAMAGE_TYPES.add("sting");
        STING_DAMAGE_TYPES.add("cactus");
        STING_DAMAGE_TYPES.add("sweetBerryBush");
        STING_DAMAGE_TYPES.add("sadiroot");
        HAZARD_DAMAGE_TYPES.add("lightningBolt");
        HAZARD_DAMAGE_TYPES.add("cold");
        HAZARD_DAMAGE_TYPES.add("lightning");
        HAZARD_EFFECTS.add(MobEffects.f_19614_);
        HAZARD_EFFECTS.add(MobEffects.f_19615_);
        HAZARD_EFFECTS.add((MobEffect)CoreMobEffects.CHILLED.get());
        HAZARD_EFFECTS.add((MobEffect)CoreMobEffects.SHOCKED.get());
    }
}

