/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.options;

import cofh.core.client.particle.options.CoFHParticleOptions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class ColorParticleOptions
extends CoFHParticleOptions {
    public final int rgba0;
    public static final Function<ParticleType<ColorParticleOptions>, Codec<ColorParticleOptions>> CODEC = type -> RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("size").forGetter(options -> Float.valueOf(options.size)), (App)Codec.FLOAT.fieldOf("duration").forGetter(options -> Float.valueOf(options.duration)), (App)Codec.INT.fieldOf("rgba0").forGetter(options -> options.rgba0)).apply((Applicative)builder, (size, duration, rgba) -> new ColorParticleOptions((ParticleType<? extends ColorParticleOptions>)type, size.floatValue(), duration.floatValue(), (int)rgba)));
    public static final ParticleOptions.Deserializer<ColorParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<ColorParticleOptions>(){

        @Nonnull
        public ColorParticleOptions fromCommand(ParticleType<ColorParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            return new ColorParticleOptions((ParticleType<? extends ColorParticleOptions>)type, reader);
        }

        @Nonnull
        public ColorParticleOptions fromNetwork(ParticleType<ColorParticleOptions> type, FriendlyByteBuf buf) {
            return new ColorParticleOptions(type, buf.readFloat(), buf.readFloat(), buf.readInt());
        }
    };

    public ColorParticleOptions(ParticleType<? extends ColorParticleOptions> type, float size, float duration, int rgba) {
        super(type, size, duration);
        this.rgba0 = rgba;
    }

    public ColorParticleOptions(ParticleType<? extends ColorParticleOptions> type, float size, float duration) {
        this(type, size, duration, -1);
    }

    public ColorParticleOptions(ParticleType<? extends ColorParticleOptions> type) {
        this(type, 1.0f, 1.0f, -1);
    }

    protected ColorParticleOptions(ParticleType<? extends ColorParticleOptions> type, StringReader reader) throws CommandSyntaxException {
        super(type, reader);
        reader.expect(' ');
        this.rgba0 = reader.readInt();
    }

    @Override
    public void m_7711_(FriendlyByteBuf buf) {
        super.m_7711_(buf);
        buf.writeInt(this.rgba0);
    }

    @Override
    public String m_5942_() {
        return super.m_5942_() + ", " + String.format("0x%08X", this.rgba0);
    }
}

