/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.CylindricalParticle;
import cofh.core.client.particle.options.CylindricalParticleOptions;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector4f;
import java.util.SplittableRandom;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WindVortexParticle
extends CylindricalParticle {
    private WindVortexParticle(CylindricalParticleOptions data, ClientLevel level, double x, double y, double z, double xDir, double yDir, double zDir) {
        super(data, level, x, y, z, xDir, yDir, zDir);
        this.f_107204_ = this.f_107231_ = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        float r;
        float rot;
        int i;
        SplittableRandom rand = new SplittableRandom(this.seed);
        float time = (float)this.f_107224_ + partialTicks - (float)rand.nextDouble(this.fLifetime * 0.25f);
        if (time < 0.0f || time > this.fLifetime) {
            return;
        }
        if (!this.rotation.equals((Object)Quaternion.f_80118_)) {
            stack.m_85845_(this.rotation);
        }
        float progress = time / this.fLifetime;
        float easePlat = MathHelper.easePlateau(progress);
        int a = MathHelper.clamp((int)((float)(this.rgba0 & 0xFF) * easePlat), 0, 255);
        stack.m_85841_(this.size * 0.2f, this.height * rand.nextFloat(-0.5f, 0.5f), this.size * 0.2f);
        float incr = 0.1308997f;
        Vector4f[] poss = new Vector4f[rand.nextInt(10, 20)];
        float angle = 3.125f * (1.0f - progress);
        int outer = MathHelper.clamp(MathHelper.ceil(angle / incr), 0, poss.length);
        for (i = 0; i < outer; ++i) {
            rot = angle - (float)i * incr;
            r = 0.5f + 0.3f * rot * (1.0f - MathHelper.cos(rot));
            float y = 0.25f + 0.25f * (1.0f - MathHelper.cos(rot * 0.32f * (float)Math.PI * 0.5f));
            poss[i] = new Vector4f(r * MathHelper.cos(rot += this.f_107231_), y, r * MathHelper.sin(rot), 1.0f);
        }
        for (i = outer; i < poss.length; ++i) {
            rot = angle - (float)i * incr;
            r = 0.5f;
            poss[i] = new Vector4f(r * MathHelper.cos(rot += this.f_107231_), 0.25f, r * MathHelper.sin(rot), 1.0f);
        }
        VFXHelper.renderStreamLine(stack, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT), packedLight, poss, this.rgba0 & 0xFFFFFF00 | a, VFXHelper.getWidthFunc((float)rand.nextDouble(0.04f, 0.05f)));
        VFXHelper.renderCyclone(stack, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT), packedLight, 1, (float)rand.nextDouble(0.04f, 0.05f), progress * 0.5f + (float)rand.nextDouble(420.0), (float)a * 0.00392157f);
    }

    @Override
    protected void setDuration(float duration) {
        this.fLifetime = duration;
        this.f_107225_ = MathHelper.ceil(this.fLifetime * 1.25f);
    }

    @Nonnull
    public static ParticleProvider<CylindricalParticleOptions> factory(SpriteSet spriteSet) {
        return WindVortexParticle::new;
    }
}

