/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.PointToPointParticle;
import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.init.CoreParticles;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShardParticle
extends PointToPointParticle {
    protected float speed;

    private ShardParticle(BiColorParticleOptions data, ClientLevel level, double sx, double sy, double sz, double ex, double ey, double ez) {
        super(data, level, sx, sy, sz, ex, ey, ez);
        Vec3 disp = new Vec3(ex - sx, ey - sy, ez - sz);
        Vec3 vel = disp.m_82490_((double)(1.0f / this.fLifetime));
        this.f_107215_ = vel.f_82479_;
        this.f_107216_ = vel.f_82480_;
        this.f_107217_ = vel.f_82481_;
        this.speed = (float)vel.m_82553_();
        this.f_172258_ = 1.0f;
        this.f_107219_ = true;
        this.m_5989_();
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        } else if ((float)this.f_107224_ < this.fLifetime) {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
        ++this.f_107224_;
    }

    public void m_6257_(double dx, double dy, double dz) {
        if (this.f_107219_ && dx * dx + dy * dy + dz * dz < 10000.0) {
            Vec3 pos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
            float time = Math.min(this.fLifetime - (float)this.f_107224_, 1.0f);
            Vec3 step = new Vec3(dx * (double)time, dy * (double)time, dz * (double)time);
            Vec3 next = pos.m_82549_(step);
            Vec3 collide = this.f_107208_.m_45547_(new ClipContext(pos, next, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_82450_();
            Vec3 delta = collide.m_82546_(pos);
            double distSqr = delta.m_82556_();
            if ((double)(this.speed * this.speed) - distSqr > (double)0.001f) {
                this.fLifetime = (float)this.f_107224_ + (float)Math.sqrt(distSqr) / this.speed;
            }
            if ((float)(this.f_107224_ + 1) >= this.fLifetime) {
                this.f_107208_.m_7106_((ParticleOptions)new ColorParticleOptions((ParticleType<? extends ColorParticleOptions>)((ParticleType)CoreParticles.BLAST.get()), this.size * 0.25f, 6 + this.f_107223_.m_188503_(4), this.rgba0), collide.f_82479_, collide.f_82480_, collide.f_82481_, 0.0, 0.0, 0.0);
            }
            dx = delta.f_82479_;
            dy = delta.f_82480_;
            dz = delta.f_82481_;
        }
        this.f_107212_ += dx;
        this.f_107213_ += dy;
        this.f_107214_ += dz;
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        float time = (float)this.f_107224_ + partialTicks - 1.0f;
        float progress = time / this.fLifetime;
        if (this.fLifetime < time) {
            return;
        }
        stack.m_85845_(VFXHelper.alignVertical(new Vector3f((float)this.f_107215_, (float)this.f_107216_, (float)this.f_107217_)));
        PoseStack.Pose last = stack.m_85850_();
        Matrix4f pose = last.m_85861_();
        Matrix3f norm = last.m_85864_();
        Vector4f start = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        start.m_123607_(pose);
        Vector4f end = new Vector4f(0.0f, -this.speed * Math.min(time, 1.0f), 0.0f, 1.0f);
        end.m_123607_(pose);
        Vec2 perp = VFXHelper.axialPerp(start, end, 1.0f);
        float w = 0.12f;
        float xs = perp.f_82470_ * w;
        float ys = perp.f_82471_ * w;
        VertexConsumer consumer = buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT);
        int r = this.rgba1 >> 24 & 0xFF;
        int g = this.rgba1 >> 16 & 0xFF;
        int b = this.rgba1 >> 8 & 0xFF;
        int a = this.rgba1 & 0xFF;
        new VFXHelper.VFXNode(start.m_123601_() + xs, start.m_123601_() - xs, start.m_123615_() + ys, start.m_123615_() - ys, start.m_123616_(), w).renderStart(norm, consumer, packedLight, r, g, b, a);
        new VFXHelper.VFXNode(end.m_123601_(), end.m_123601_(), end.m_123615_(), end.m_123615_(), end.m_123616_(), w * 0.1f).renderEnd(norm, consumer, packedLight, r, g, b, a);
        if ((this.rgba0 | 0xFF) != (this.rgba1 | 0xFF)) {
            buffer.m_6299_(RenderTypes.LINEAR_GLOW);
            buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT);
        }
        RenderHelper.renderBipyramid(stack, consumer, packedLight, this.rgba0, 4, 0.6f, 0.1f);
    }

    @Override
    public void setDuration(float duration) {
        float speed = this.fLifetime / duration;
        this.f_107215_ *= (double)speed;
        this.f_107216_ *= (double)speed;
        this.f_107217_ *= (double)speed;
        this.speed *= speed;
        super.setDuration(duration);
    }

    @Nonnull
    public static ParticleProvider<BiColorParticleOptions> factory(SpriteSet spriteSet) {
        return ShardParticle::new;
    }
}

