/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.TextureParticleCoFH;
import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MistParticle
extends TextureParticleCoFH {
    protected float baseAlpha = 1.0f;

    protected MistParticle(ColorParticleOptions data, ClientLevel level, SpriteSet sprites, double x, double y, double z, double dx, double dy, double dz) {
        super(data, level, sprites, x, y, z);
        float var = 0.05f;
        this.f_107215_ = dx + (double)this.rand.nextFloat(-var, var);
        this.f_107216_ = dy + (double)this.rand.nextFloat(-var, var);
        this.f_107217_ = dz + (double)this.rand.nextFloat(-var, var);
        this.f_107204_ = this.f_107231_ = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
        this.m_108339_(sprites);
    }

    @Override
    public void setColor(int rgba) {
        this.f_107227_ = (float)(rgba >> 24 & 0xFF) * 0.0039215684f;
        this.f_107228_ = (float)(rgba >> 16 & 0xFF) * 0.0039215684f;
        this.f_107229_ = (float)(rgba >> 8 & 0xFF) * 0.0039215684f;
        this.baseAlpha = (float)(rgba & 0xFF) * 0.0039215684f;
    }

    @Override
    public void m_5744_(VertexConsumer consumer, Camera info, float partialTicks) {
        float progress = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        float q = 2.0f * progress - 1.0f;
        q *= q;
        this.f_107230_ = this.baseAlpha * Math.max((1.0f - q * q) * MathHelper.cos(0.7853982f * progress), 0.0f);
        this.f_107663_ = this.f_107221_ * MathHelper.sin(0.7853982f * (progress + 1.0f));
        super.m_5744_(consumer, info, partialTicks);
    }

    public ParticleRenderType m_7556_() {
        return RenderTypes.PARTICLE_SHEET_OVER;
    }

    @Nonnull
    public static ParticleProvider<ColorParticleOptions> factory(SpriteSet spriteSet) {
        return (data, level, x, y, z, dx, dy, dz) -> new MistParticle((ColorParticleOptions)data, level, spriteSet, x, y, z, dx, dy, dz);
    }
}

