/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.TextureParticleCoFH;
import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FireParticle
extends TextureParticleCoFH {
    protected float baseAlpha;

    private FireParticle(ColorParticleOptions data, ClientLevel level, SpriteSet sprites, double x, double y, double z, double dx, double dy, double dz) {
        super(data, level, sprites, x, y, z);
        this.f_107215_ = dx;
        this.f_107216_ = dy;
        this.f_107217_ = dz;
        this.m_107264_(x + dx, y + dy, z + dz);
        this.f_107226_ = -0.3f;
        this.f_172258_ = 0.9f;
        this.m_108339_(this.sprites);
        this.setColor(-1);
        this.f_107204_ = this.f_107231_ = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
    }

    @Override
    public void setColor(int rgba) {
        this.f_107227_ = (float)(rgba >> 24 & 0xFF) * 0.0039215684f;
        this.f_107228_ = (float)(rgba >> 16 & 0xFF) * 0.0039215684f;
        this.f_107229_ = (float)(rgba >> 8 & 0xFF) * 0.0039215684f;
        this.baseAlpha = (float)(rgba & 0xFF) * 0.0039215684f;
    }

    @Override
    public void m_5744_(VertexConsumer consumer, Camera info, float partialTicks) {
        float progress = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        float easeCos = MathHelper.cos(progress * 0.5f * (float)Math.PI);
        this.f_107230_ = this.baseAlpha * easeCub;
        super.m_5744_(consumer, info, partialTicks);
    }

    public ParticleRenderType m_7556_() {
        return RenderTypes.PARTICLE_SHEET_ADDITIVE_MUTLIPLY;
    }

    public int m_6355_(float partialTicks) {
        return 0xF000F0;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
    }

    @Nonnull
    public static ParticleProvider<ColorParticleOptions> factory(SpriteSet spriteSet) {
        return (data, level, x, y, z, dx, dy, dz) -> new FireParticle((ColorParticleOptions)data, level, spriteSet, x, y, z, dx, dy, dz);
    }
}

