/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.CylindricalParticle;
import cofh.core.client.particle.options.CylindricalParticleOptions;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.SplittableRandom;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlastWaveParticle
extends CylindricalParticle {
    private BlastWaveParticle(CylindricalParticleOptions data, ClientLevel level, double x, double y, double z, double xDir, double yDir, double zDir) {
        super(data, level, x, y, z, xDir, yDir, zDir);
        this.f_107219_ = false;
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int packedLightIn, float partialTicks) {
        float time = (float)this.f_107224_ + partialTicks;
        if (this.fLifetime < time) {
            return;
        }
        SplittableRandom rand = new SplittableRandom(this.seed);
        float progress = time / this.fLifetime;
        float easeSin = MathHelper.sin(progress * (float)Math.PI * 0.5f);
        float easeCub = MathHelper.easeOutCubic(progress);
        VFXHelper.renderCyclone(stack, buffer, this.m_6355_(partialTicks), this.size * easeSin, this.height * easeSin, 2, 0.2f * easeCub, time * 0.05f + (float)rand.nextDouble(69.0), 0.5f * MathHelper.easePlateau(progress));
    }

    @Nonnull
    public static ParticleProvider<CylindricalParticleOptions> factory(SpriteSet spriteSet) {
        return BlastWaveParticle::new;
    }
}

