/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.PointToPointParticle;
import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BeamParticle
extends PointToPointParticle {
    protected final Vector3f dest;

    private BeamParticle(BiColorParticleOptions data, ClientLevel level, double sx, double sy, double sz, double ex, double ey, double ez) {
        super(data, level, sx, sy, sz, ex, ey, ez);
        float dx = (float)(ex - sx);
        float dy = (float)(ey - sy);
        float dz = (float)(ez - sz);
        this.dest = new Vector3f(dx, dy, dz);
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        float time = (float)this.f_107224_ + partialTicks;
        if (this.fLifetime < time) {
            return;
        }
        float progress = time / (float)this.f_107225_;
        float easeCos = 0.5f * MathHelper.cos(progress * (float)Math.PI * 0.5f) + 0.5f;
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        VFXHelper.alignVertical(stack, Vector3f.f_176763_, this.dest);
        VFXHelper.renderBeam(stack, buffer, packedLight, this.size * easeCos, VFXHelper.alphaScale(this.rgba0, easeCub), VFXHelper.alphaScale(this.rgba1, easeCub));
    }

    @Override
    public int m_6355_(float pTicks) {
        return 0xF000F0;
    }

    @Override
    public int getLightColor(float pTicks, double x, double y, double z) {
        return 0xF000F0;
    }

    @Nonnull
    public static ParticleProvider<BiColorParticleOptions> factory(SpriteSet spriteSet) {
        return BeamParticle::new;
    }
}

