/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class TextureParticleCoFH
extends TextureSheetParticle {
    protected final SpriteSet sprites;
    protected float fLifetime;
    protected RandomGenerator rand = new SplittableRandom();

    protected TextureParticleCoFH(ColorParticleOptions data, ClientLevel level, SpriteSet sprites, double x, double y, double z) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.setSize(data.size);
        this.setDuration(data.duration);
        this.setColor(data.rgba0);
    }

    protected TextureParticleCoFH(ColorParticleOptions data, ClientLevel level, SpriteSet sprites, double x, double y, double z, double dx, double dy, double dz) {
        super(level, x, y, z, dx, dy, dz);
        this.sprites = sprites;
        this.setSize(data.size);
        this.setDuration(data.duration);
        this.setColor(data.rgba0);
    }

    public void setDuration(float duration) {
        this.fLifetime = duration;
        this.f_107225_ = MathHelper.ceil(this.fLifetime);
    }

    public void setSize(float size) {
        float half = size * 0.5f;
        Vec3 pos = new Vec3(this.f_107212_, this.f_107213_ + (double)half, this.f_107214_);
        this.m_107259_(new AABB(pos, pos).m_82400_((double)half));
        this.f_107221_ = this.f_107222_ = size;
        this.f_107663_ = size;
    }

    public void setColor(int rgba) {
        this.f_107227_ = (float)(rgba >> 24 & 0xFF) * 0.0039215684f;
        this.f_107228_ = (float)(rgba >> 16 & 0xFF) * 0.0039215684f;
        this.f_107229_ = (float)(rgba >> 8 & 0xFF) * 0.0039215684f;
        this.f_107230_ = (float)(rgba & 0xFF) * 0.0039215684f;
    }

    public void m_5744_(VertexConsumer consumer, Camera cam, float pTicks) {
        if ((float)this.f_107224_ + pTicks > this.fLifetime) {
            return;
        }
        super.m_5744_(consumer, cam, pTicks);
    }
}

