/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block.entity;

import cofh.core.block.entity.ITileXpHandler;
import cofh.core.network.packet.client.TileGuiPacket;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.IConveyableData;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.api.block.entity.ITileCallback;
import cofh.lib.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileCoFH
extends BlockEntity
implements ITileCallback,
IPacketHandlerTile,
ITileXpHandler,
IConveyableData {
    protected int numPlayersUsing;

    public TileCoFH(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && Utils.isClientWorld(this.f_58857_) && this instanceof IAreaEffectTile) {
            ProxyUtils.addAreaEffectTile((IAreaEffectTile)((Object)this));
        }
        this.m_6339_();
    }

    public void m_7651_() {
        if (this instanceof IAreaEffectTile) {
            ProxyUtils.removeAreaEffectTile((IAreaEffectTile)((Object)this));
        }
        super.m_7651_();
    }

    public int getPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void addPlayerUsing() {
        ++this.numPlayersUsing;
    }

    public void removePlayerUsing() {
        --this.numPlayersUsing;
    }

    public void receiveGuiNetworkData(int id, int data) {
    }

    public void sendGuiNetworkData(AbstractContainerMenu container, Player player) {
        if (this.hasGuiPacket() && player instanceof ServerPlayer && !(player instanceof FakePlayer)) {
            TileGuiPacket.sendToClient(this, (ServerPlayer)player);
        }
    }

    public boolean onActivatedDelegate(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        return this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(handler -> FluidHelper.interactWithHandler(player.m_21120_(hand), handler, player, hand)).orElse(false);
    }

    public boolean hasGuiPacket() {
        return true;
    }

    protected Object getSound() {
        return null;
    }

    protected void markDirtyFast() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.f_58858_);
        }
    }

    public boolean playerWithinDistance(Player player, double distanceSq) {
        return !this.m_58901_() && this.f_58858_.m_203193_((Position)player.m_20182_()) <= distanceSq;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public Block block() {
        return this.m_58900_().m_60734_();
    }

    @Override
    public BlockState state() {
        return this.m_58900_();
    }

    @Override
    public BlockPos pos() {
        return this.f_58858_;
    }

    @Override
    public Level world() {
        return this.f_58857_;
    }
}

