/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.recipe;

import alexthw.ars_elemental.registry.ModRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class NetheriteUpgradeRecipe
extends EnchantingApparatusRecipe {
    public NetheriteUpgradeRecipe(ResourceLocation pRecipeId, Ingredient reagent, List<Ingredient> stacks, int cost) {
        this.reagent = reagent;
        this.pedestalItems = stacks;
        this.sourceCost = cost;
        this.id = pRecipeId;
        this.keepNbtOfReagent = true;
    }

    public boolean doesReagentMatch(ItemStack reag) {
        return super.doesReagentMatch(reag) && !reag.m_41777_().m_41784_().m_128441_("ae_netherite");
    }

    public ItemStack getResult(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        ItemStack temp = reagent.m_41777_();
        temp.m_41784_().m_128379_("ae_netherite", true);
        return temp;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRegistry.NETHERITE_UP.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.NETHERITE_UP_SERIALIZER.get();
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_elemental:netherite_upgrade");
        jsonobject.addProperty("sourceCost", (Number)this.getSourceCost());
        JsonArray reagent = new JsonArray();
        reagent.add(this.reagent.m_43942_());
        jsonobject.add("reagent", (JsonElement)reagent);
        JsonArray pedestalArr = new JsonArray();
        for (Ingredient i : this.pedestalItems) {
            JsonObject object = new JsonObject();
            object.add("item", i.m_43942_());
            pedestalArr.add((JsonElement)object);
        }
        jsonobject.add("pedestalItems", (JsonElement)pedestalArr);
        return jsonobject;
    }

    public static class Serializer
    implements RecipeSerializer<NetheriteUpgradeRecipe> {
        public NetheriteUpgradeRecipe fromJson(ResourceLocation pRecipeId, JsonObject json) {
            Ingredient reagent = Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"reagent"));
            int cost = json.has("sourceCost") ? GsonHelper.m_13927_((JsonObject)json, (String)"sourceCost") : 0;
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (JsonElement e : pedestalItems) {
                JsonObject obj = e.getAsJsonObject();
                Ingredient input = GsonHelper.m_13885_((JsonObject)obj, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)obj, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)obj, (String)"item"));
                stacks.add(input);
            }
            return new NetheriteUpgradeRecipe(pRecipeId, reagent, stacks, cost);
        }

        @Nullable
        public NetheriteUpgradeRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buffer) {
            int length = buffer.readInt();
            Ingredient reagent = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            int cost = buffer.readInt();
            return new NetheriteUpgradeRecipe(pRecipeId, reagent, stacks, cost);
        }

        public void toNetwork(FriendlyByteBuf buf, NetheriteUpgradeRecipe recipe) {
            buf.writeInt(recipe.pedestalItems.size());
            recipe.reagent.m_43923_(buf);
            for (Ingredient i : recipe.pedestalItems) {
                i.m_43923_(buf);
            }
            buf.writeInt(recipe.sourceCost);
        }
    }
}

