/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.armor;

import alexthw.ars_elemental.registry.ModPotions;
import com.hollingsworth.arsnouveau.api.perk.IEffectResolvePerk;
import com.hollingsworth.arsnouveau.api.perk.Perk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class ShockPerk
extends Perk
implements IEffectResolvePerk {
    public static ShockPerk INSTANCE = new ShockPerk();

    public ShockPerk() {
        super(new ResourceLocation("ars_elemental", "thread_shock"));
    }

    public String getLangDescription() {
        return "Damaging effects cause the target to be shocked for a short duration before the effect resolves.";
    }

    public String getLangName() {
        return "Shocking";
    }

    public void onPreResolve(HitResult rayTraceResult, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver, AbstractEffect effect, PerkInstance perkInstance) {
        if (effect instanceof IDamageEffect) {
            LivingEntity livingEntity;
            EntityHitResult entityHitResult;
            Entity entity;
            IDamageEffect damageEffect = (IDamageEffect)effect;
            if (rayTraceResult instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)rayTraceResult).m_82443_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity) != shooter && damageEffect.canDamage(shooter, spellStats, spellContext, resolver, entityHitResult.m_82443_())) {
                int value = perkInstance.getSlot().value;
                livingEntity.m_7292_(new MobEffectInstance(value < 3 ? (MobEffect)com.hollingsworth.arsnouveau.common.potions.ModPotions.SHOCKED_EFFECT.get() : (MobEffect)ModPotions.LIGHTNING_LURE.get(), value * 5 * 20, value < 3 ? value : 1));
            }
        }
    }

    public void onPostResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver, AbstractEffect effect, PerkInstance perkInstance) {
    }
}

