/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.api.IPropagator;
import alexthw.ars_elemental.common.entity.spells.EntityHomingProjectile;
import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropagatorHoming
extends ElementalAbstractEffect
implements IPropagator {
    public static PropagatorHoming INSTANCE = new PropagatorHoming();

    public PropagatorHoming() {
        super("propagator_homing", "Propagate Homing");
    }

    @Override
    public void propagate(Level world, Vec3 pos, LivingEntity shooter, SpellStats stats, SpellResolver resolver) {
        int numSplits = 1 + stats.getBuffCount((AbstractAugment)AugmentSplit.INSTANCE);
        ArrayList<EntityHomingProjectile> projectiles = new ArrayList<EntityHomingProjectile>();
        for (int i = 0; i < numSplits; ++i) {
            projectiles.add(new EntityHomingProjectile(world, resolver));
        }
        float velocity = MethodHomingProjectile.getProjectileSpeed(stats);
        int opposite = -1;
        int counter = 0;
        Vec3 direction = pos.m_82546_(shooter.m_20182_());
        for (EntityHomingProjectile proj : projectiles) {
            proj.m_146884_(pos.m_82520_(0.0, 1.0, 0.0));
            proj.setIgnored(MethodHomingProjectile.basicIgnores(shooter, stats.hasBuff((AbstractAugment)AugmentSensitive.INSTANCE), resolver.spell));
            if (direction.m_82554_(Vec3.f_82478_) < 0.25) {
                proj.shoot((Entity)shooter, shooter.m_146909_(), shooter.m_146908_() + (float)(Math.round((double)counter / 2.0) * 5L * (long)opposite), 0.0f, velocity, 0.8f);
                opposite *= -1;
                ++counter;
            } else {
                proj.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, 0.8f);
            }
            world.m_7967_((Entity)proj);
        }
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.copyResolver((HitResult)rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    public int getDefaultManaCost() {
        return 400;
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return MethodHomingProjectile.INSTANCE.getCompatibleAugments();
    }

    public SpellTier getTier() {
        return SpellTier.THREE;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }
}

